/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Comparator;
import java.util.Map;
import javax.inject.Named;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MacroWrapperMacro
implements Macro {
    @ComponentImport
    private final Renderer renderer;

    @Autowired
    public MacroWrapperMacro(Renderer renderer) {
        this.renderer = renderer;
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> map, String unrenderedNestedMacro, ConversionContext conversionContext) throws MacroExecutionException {
        if (!unrenderedNestedMacro.contains("<ac:structured-macro ac:name=\"children\"")) {
            return "DPT wrapper macro: Unsupported content";
        }
        String renderedNestedMacro = this.renderer.renderWithResult(unrenderedNestedMacro, conversionContext).getRender();
        Document doc = Jsoup.parse(renderedNestedMacro);
        this.removePrefixFromPageNames(doc);
        this.reorderLinks(doc, unrenderedNestedMacro);
        return doc.body().html();
    }

    private void reorderLinks(Document doc, String unrenderedNestedMacro) {
        if (!unrenderedNestedMacro.contains("<ac:parameter ac:name=\"sort\">title</ac:parameter>")) {
            return;
        }
        Elements ulElements = doc.select(".childpages-macro.conf-macro");
        for (Element ulElement : ulElements) {
            this.reorderLiElementsInUl(ulElement);
        }
    }

    private void reorderLiElementsInUl(Element ulElement) {
        if (ulElement == null) {
            return;
        }
        Elements liElements = ulElement.children();
        liElements.sort(new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                return o1.child(0).text().compareToIgnoreCase(o2.child(0).text());
            }
        });
        for (Element liElement : liElements) {
            liElement.select("> .childpages-macro").forEach(this::reorderLiElementsInUl);
            ulElement.appendChild(liElement);
        }
    }

    private void removePrefixFromPageNames(Document document) {
        document.select(".childpages-macro > li > a").forEach(anchorNode -> this.replacePrefix((Element)anchorNode));
    }

    private void replacePrefix(Element e) {
        int indexOfChar = e.text().lastIndexOf(11037);
        if (indexOfChar == -1) {
            return;
        }
        e.text(e.text().substring(indexOfChar + 2));
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

