/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.veniture.confluence.filter.utils.ResponseWrapper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HideFilter
implements Filter {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.log.trace("doFilter");
        ResponseWrapper wrappedResponse = new ResponseWrapper((HttpServletResponse)response);
        this.log.trace("Content Type: " + wrappedResponse.getContentType());
        this.log.trace("Encoding Type: " + wrappedResponse.getCharacterEncoding());
        chain.doFilter(request, (ServletResponse)wrappedResponse);
        String out = wrappedResponse.getCaptureAsString();
        Document document = Jsoup.parse(out);
        document.select(":contains(\u2b1d)").forEach(el -> {
            if (el.children().size() < 1) {
                String[] splitByDot = el.text().split("\u2b1d");
                el.text(splitByDot[splitByDot.length - 1].trim());
            }
        });
        response.getWriter().write(document.html());
    }
}

