/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.filter.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream capture;
    private ServletOutputStream output;
    private PrintWriter writer;

    public ResponseWrapper(HttpServletResponse response) {
        super(response);
        this.capture = new ByteArrayOutputStream(response.getBufferSize());
    }

    public ServletOutputStream getOutputStream() {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called on this response.");
        }
        if (this.output == null) {
            this.output = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    ResponseWrapper.this.capture.write(b);
                }

                public void flush() throws IOException {
                    ResponseWrapper.this.capture.flush();
                }

                public void close() throws IOException {
                    ResponseWrapper.this.capture.close();
                }
            };
        }
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.output != null) {
            throw new IllegalStateException("getOutputStream() has already been called on this response.");
        }
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.capture, this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.output != null) {
            this.output.flush();
        }
    }

    public byte[] getCaptureAsBytes() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else if (this.output != null) {
            this.output.close();
        }
        return this.capture.toByteArray();
    }

    public String getCaptureAsString() throws IOException {
        return new String(this.getCaptureAsBytes(), this.getCharacterEncoding());
    }
}

