/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.filter;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.veniture.confluence.filter.utils.ResponseWrapper;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class HideFilter
implements Filter {
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    Logger log = Logger.getLogger(this.getClass());
    private FilterConfig filterConfig;

    @Autowired
    public HideFilter(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.log.trace((Object)"doFilter");
        ResponseWrapper wrappedResponse = new ResponseWrapper((HttpServletResponse)response);
        this.log.trace((Object)("Content Type: " + wrappedResponse.getContentType()));
        this.log.trace((Object)("Encoding Type: " + wrappedResponse.getCharacterEncoding()));
        chain.doFilter(request, (ServletResponse)wrappedResponse);
        String out = wrappedResponse.getCaptureAsString();
        Document document = Jsoup.parse((String)out);
        document.select(":contains(\u2b1d)").forEach(el -> {
            if (el.children().size() < 1) {
                String[] splitByDot = el.text().split("\u2b1d");
                el.text(splitByDot[splitByDot.length - 1].trim());
            }
        });
        response.getWriter().write(document.html());
    }
}

