var DPT_MOVE = {} || DPT_MOVE;
var globalMoveError = false;
DPT_MOVE.globalSettings = [];

DPT_MOVE.obs = new MutationObserver(function (mutations, observer) {
    // look through all mutations that just occured
    mutations.forEach(function (mutation) {
        //DBL.log(mutation);
        if (AJS.$(mutation.target).is("div#move-errors")) {
            globalMoveError = true;
        }
    });
});

function showDialog() {
    var newPageInfos = AJS.$('#new-parent-breadcrumbs');
    DPT_MOVE.newParentPageName = newPageInfos.length === 1 ? "dpt_toplevel" : newPageInfos.find('.last').text();
    DPT_MOVE.pageId = document.getElementsByName('ajs-page-id')[0].getAttribute('content');
    DPT_MOVE.oldDialogue = AJS.$('#move-page-dialog');

    DPT_MOVE.newDialogue = AJS.$(DoublicatePageTitles.movePageDialogue());
    AJS.dialog2(DPT_MOVE.newDialogue).show();
    DPT_MOVE.newDialogue.css('z-index', '4000');
}

$(window).load(function () {

    AJS.$(document).ajaxSuccess(function (event, xhr, settings) {
        if (settings.url === document.getElementById('confluence-base-url').content + "/pages/movepage.action" ||
            settings.url === "/pages/movepage.action" ||
            settings.url === "/confluence/pages/movepage.action") {
            DPT_MOVE.newSpaceKey = settings.data.match(/spaceKey=(\w*)/)[1];
            setTimeout(function () {
                if (globalMoveError) {
                    showDialog();
                } else {
                    console.log("No Errors found while moving!");
                }
            }, 500);
        }
    });

    DPT_MOVE.obs.observe(AJS.$('body').get(0), {
        childList: true,
        subtree: true
    });

    AJS.$(document).on("click", "#DPT-move-page", function () {
        var formData = {
            atl_token: document.getElementById('atlassian-token').content,
            pageId: DPT_MOVE.pageId,
            newSpace: DPT_MOVE.newSpaceKey,
            newParentPage: DPT_MOVE.newParentPageName,
        };

        AJS.$.ajax({
            type: 'post',
            url: document.getElementById('confluence-base-url').content + "/rest/dpt/1.0/move",
            contentType: 'application/x-www-form-urlencoded',
            data: formData
        }).done(function (data) {
            window.location.href = document.getElementById('confluence-base-url').content + "/pages/viewpage.action?pageId=" + DPT_MOVE.pageId;
        }).fail(function () {
            AJS.dialog2(DPT_MOVE.newDialogue).hide();
            AJS.dialog2(DPT_MOVE.oldDialogue).show();
            AJS.flag({
                type: 'error',
                body: 'Something went wrong!'
            });
        });
    });

    /* WHY*/
    AJS.$(document).on("click", ".aui-dialog2-header-close", function () {
        if (globalMoveError) {
            AJS.dialog2(DPT_MOVE.newDialogue).remove();
            AJS.dialog2(DPT_MOVE.oldDialogue).show();
            globalMoveError = false;
        }
    });

    AJS.$(document).on("click", "#dialog-close-button", function () {
        if (globalMoveError) {
            AJS.dialog2(DPT_MOVE.newDialogue).remove();
            AJS.dialog2(DPT_MOVE.oldDialogue).show();
            globalMoveError = false;
        }
    });

});
