/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Named
@Path(value="/move")
public class MovePageUtil {
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final SpaceManager spaceManager;

    @Autowired
    public MovePageUtil(TransactionTemplate transactionTemplate, PageManager pageManager, SpaceManager spaceManager) {
        this.transactionTemplate = transactionTemplate;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response movePage(@FormParam(value="pageId") String pageIdString, @FormParam(value="newSpace") String spaceKey, @FormParam(value="newParentPage") String parentPage) {
        Page originalPage = this.pageManager.getPage(Long.parseLong(pageIdString));
        Space space = this.spaceManager.getSpace(spaceKey);
        Page newParentPage = null;
        if (space != null) {
            newParentPage = "dpt_toplevel".equals(parentPage) ? space.getHomePage() : this.pageManager.getPage(space.getKey(), parentPage);
        }
        String newTitle = null;
        if (space != null && originalPage != null) {
            newTitle = this.getNewTitle(space, space.getName() + " \u2b1d " + originalPage.getTitle());
        }
        String finalNewTitle = newTitle;
        Page finalNewParentPage = newParentPage;
        this.transactionTemplate.execute(() -> {
            this.pageManager.saveNewVersion((ContentEntityObject)originalPage, page1 -> page1.setTitle(finalNewTitle));
            this.pageManager.movePageAsChild(originalPage, finalNewParentPage);
            assert (finalNewParentPage != null);
            finalNewParentPage.addChild(originalPage);
            return originalPage;
        });
        return Response.ok((Object)"").build();
    }

    public String getNewTitle(Space space, String title) {
        if (this.pageManager.getPage(space.getName(), title) != null) {
            return this.getNewTitle(space, space.getName() + " \u2b1d " + title);
        }
        return title;
    }
}

