/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.license;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import net.veniture.confluence.license.LicenseCheckService;
import org.springframework.stereotype.Component;

@Component
public class LicenseCheckServiceImpl
implements LicenseCheckService {
    @ComponentImport
    private PluginLicenseManager licenseMan;
    @ComponentImport
    private PluginAccessor pluginAccessor;

    public LicenseCheckServiceImpl(PluginLicenseManager licenseMan, PluginAccessor pluginAccessor) {
        this.licenseMan = licenseMan;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public PluginLicense getLicense() {
        if (this.isLicensed()) {
            return (PluginLicense)this.licenseMan.getLicense().get();
        }
        return null;
    }

    @Override
    public boolean isLicensed() {
        Plugin plugin = this.pluginAccessor.getPlugin(this.licenseMan.getPluginKey());
        String pluginDescription = plugin.getPluginInformation().getDescription();
        if (pluginDescription.contains("V-NO-LICENSE-CHECK")) {
            return true;
        }
        if (!this.licenseMan.getLicense().isDefined()) {
            return false;
        }
        return ((PluginLicense)this.licenseMan.getLicense().get()).isValid();
    }

    @Override
    public boolean isEvaluation() {
        if (!this.licenseMan.getLicense().isDefined()) {
            return false;
        }
        return ((PluginLicense)this.licenseMan.getLicense().get()).isEvaluation();
    }
}

