var DPT_HREF = {} || DPT_HREF;
DPT_HREF.prevent = true;
DPT_HREF.obs = new MutationObserver(function (mutations, observer) {
    // look through all mutations that just occurred
    mutations.forEach(function (mutation) {
        if (AJS.$(mutation.target).is("li")) {
            console.log(mutation.target);
            DPT_HREF.replaceTitles(AJS.$(mutation.target).find('.rw_item_content a'));
        }
    });
});

DPT_HREF.replaceTitles = function (element) {
    element.each(function () {
        var target = AJS.$(this);
        var text = target.text();
        var index = text.lastIndexOf("\u2B1D");
        if (index !== -1) {
            target.text(text.substr(index + 2))
        }

        target.css('visibility', 'visible!important');
        target.css('visibility', 'visible');
    })
}


$(window).load(function () {
    DPT_HREF.replaceTitles(AJS.$('.rw_item_content a'));

    DPT_HREF.obs.observe(AJS.$('body').get(0), {
        childList: true,
        subtree: true
    });
});