/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.filter;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.veniture.confluence.filter.utils.ResponseWrapper;
import org.apache.log4j.Logger;

public class RefinedThemeFilter
implements Filter {
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    Logger log = Logger.getLogger(this.getClass());
    private FilterConfig filterConfig;

    @Inject
    public RefinedThemeFilter(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.log.trace((Object)"doFilter");
        String url = ((HttpServletRequest)request).getRequestURL().toString();
        if (url.contains("/json/search.action")) {
            chain.doFilter(request, response);
            return;
        }
        ResponseWrapper wrappedResponse = new ResponseWrapper((HttpServletResponse)response);
        boolean isViewport = false;
        if (url.contains("pagetree")) {
            wrappedResponse.setContentType("text/html;charset=UTF-8");
            isViewport = true;
        }
        if (wrappedResponse.getContentType() != null && wrappedResponse.getContentType().equals("text/html;charset=UTF-8") || isViewport) {
            try {
                this.log.trace((Object)"Check licence");
                if (this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().get() != null && ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid()) {
                    this.log.trace((Object)"ReplaceRefined");
                    chain.doFilter(request, (ServletResponse)wrappedResponse);
                    PrintWriter respStream = response.getWriter();
                    String out = ((Object)((Object)wrappedResponse)).toString();
                    if (out.contains("\u2b1d")) {
                        out = out.replaceAll("[^>^\"]*\\s+[\u00e2\u00ac|\u2b1d]|\u00ac|[^ -~]\\s+", "");
                        this.log.trace((Object)"venITure was here");
                    }
                    respStream.write(out);
                    return;
                }
            }
            catch (NoSuchElementException e) {
                chain.doFilter(request, response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.filterConfig = null;
    }
}

