AJS.toInit(function ()
{
    AJS.$("#efmoderators-select-user").auiSelect2(
    {
        ajax: {
            url: AJS.params.contextPath + "/rest/prototype/1/search.json",
            dataType: 'json',
            contentType: 'application/json',
            type: 'GET',
            quietMillis: 500,
            data: function (params)
            {
                if(params.length > 1)
                {
                    return {
                        'max-results': "10",
                        'query':       params,
                        'search':      "user"
                    }
                }
                return {
                    'max-results': "1",
                    'query':       "admin",
                    'search':      "user"
                }
            },
            results: function (data)
            {
            console.log(data);
                // data = {"totalSize":1,"result":[{"id":"4489220","type":"user","title":"Tom Grow","wikiLink":"[~alan]","createdDate":{"friendly":"yesterday at 9:41 PM","date":"2017-07-07T21:41:34+1000"},"creator":{"links":[{"href":"http://beast-pc:1990/confluence/rest/prototype/1/user/non-system/admin","rel":"self"}],"avatarUrl":"/confluence/images/icons/profilepics/default.png","displayableEmail":"admin@example.com","anonymous":false,"name":"admin","displayName":"admin"},"lastModifier":{"links":[{"href":"http://beast-pc:1990/confluence/rest/prototype/1/user/non-system/admin","rel":"self"}],"avatarUrl":"/confluence/images/icons/profilepics/default.png","displayableEmail":"admin@example.com","anonymous":false,"name":"admin","displayName":"admin"},"username":"alan","userKey":"4028818d5d1ccce6015d1cdae8ea0003","thumbnailLink":{"href":"/confluence/images/icons/profilepics/default.png","type":"image/png","rel":"thumbnail"},"link":[{"href":"http://BEAST-PC:1990/confluence/display/~alan","type":"text/html","rel":"alternate"},{"href":"http://BEAST-PC:1990/confluence/spaces/flyingpdf/pdfpageexport.action?pageId=4489220","type":"application/pdf","rel":"alternate"},{"href":"http://beast-pc:1990/confluence/rest/prototype/1/content/4489220","rel":"self"}]}],"group":[]}
                // parse the results into the format expected by Select2
                var results = [];
                if(data.totalSize > 0)
                {
                    $.each(data.result, function(index, item){
                        console.log(item);
                        results.push({id: item.userKey, text:item.title});
                    });
                }
                return {
                  results: results
                };
            }
        },
        placeholder: "Add Moderator",
        dropdownCssClass : 'ef-select-width',
        formatSearching: function() { return "Start typing user name..."; }
    }).on("select2-close", function () {
        setTimeout(function() {
            $('.select2-container-active').removeClass('select2-container-active');
            $(':focus').blur();
        }, 1);
    });

    $(document).on('change', '#efmoderators-select-user', function(e)
    {
        AJS.$("#ef-add-moderator").prop('disabled', false);
    });

    // Execute the Add moderator function
    AJS.$("#ef-add-moderator").click(function(e)
    {
        var userKey = $("#efmoderators-select-user").select2("val");
        console.log("userKey: " + userKey);

        e.preventDefault();
        if(userKey != "")
        {
            $.post(AJS.params.contextPath + "/plugins/servlet/easyforums/setModerators",
            {
                'action'  : "add",
                'pageId'  : AJS.params.pageId,
                'userKey' : userKey,
                atl_token:  AJS.Meta.get("atl-token")
            }).success(function(data, statusText, xhr) {
                console.log(data);
                console.log(xhr.status);
                if(xhr.status == 200)
                {
                    $('#ef-moderator-list')["0"].innerHTML = data;
                }
            }).error(function(jqXHR) {
                handleError(jqXHR.status, jqXHR.responseText);
            });
        }
    });

    $(document).on('click', '.ef-remove-moderator', function(e)
    {
        console.log(this);
        var userKey = $(this).attr("data-key");
        console.log("userKey: " + userKey);

        e.preventDefault();
        if(userKey != "")
        {
            $.post(AJS.params.contextPath + "/plugins/servlet/easyforums/setModerators",
            {
                action  : "remove",
                pageId  : AJS.params.pageId,
                userKey : userKey,
                atl_token: AJS.Meta.get("atl-token")
            }).success(function(data, statusText, xhr) {
                console.log(data);
                console.log(xhr.status);
                if(xhr.status == 200)
                {
                    $('#ef-moderator-list')["0"].innerHTML = data;
                }
            }).error(function(jqXHR) {
                handleError(jqXHR.status, jqXHR.responseText);
            });
        }
    });

    // Handle Topic Creators control
    AJS.$("#ef-moderators-select-topic-creators").auiSelect2({
        minimumResultsForSearch: Infinity
    });

    $(document).on('change', '#ef-moderators-select-topic-creators', function(e)
    {
        AJS.$("#ef-set-topic-creator").prop('disabled', false);
    });

    AJS.$("#ef-set-topic-creator").click(function(e)
    {
        var groupName = $("#ef-moderators-select-topic-creators").find(":selected").text();
        console.log("groupName: " + groupName);

        e.preventDefault();
        if(groupName != "")
        {
            $.post(AJS.params.contextPath + "/plugins/servlet/easyforums/setTopicCreators",
            {
                'pageId'    : AJS.params.pageId,
                'groupName' : groupName,
                 atl_token  : AJS.Meta.get("atl-token")
            }).success(function(data, statusText, xhr) {
                AJS.$("#ef-set-topic-creator").prop('disabled', true);
            }).error(function(jqXHR) {
                handleError(jqXHR.status, jqXHR.responseText);
            });
        }
    });

    AJS.$("#ef-forum-settings-control").click(function(e)
    {
        var controls = $("#ef-forum-settings");

        if(controls.is(':visible'))
            controls.hide();
        else
            controls.show();
    });
});
