AJS.toInit(function ()
{
    // ... your initialisation code here
    AJS.$("#main").after(EasyForums.Templates.Soy.efMessageDiv());

    function handleError(error, message)
    {
        if(!message)
        {
            if (error == 503) {
                // DC read-only mode....
                message = "Confluence is in READ-ONLY mode, this action is not available";
            } else if (error == 401) {
                // unauthorised, we don't need to display a message here....
                return;
            } else if (error == 402) {  // payment req
                // license error
                message = AJS.I18n.getText("net.kentcom.easy-forums.unlicensed");
            } else {
                // 400 bad request, should not happen
                message = "Internal Server error, contact Administrator and refer to logs";
            }
        }
        console.log(error);

        AJS.messages.warning("#efMessageDiv",
        {
           title: AJS.I18n.getText("net.kentcom.easy-forums.plugin.name"),
           body: message,
           closeable: true,
           fadeout: true,
           delay  : 5000
        });
    }

    function renameComments()
    {
        var heading = $('#comments-section-title');
        if(heading.length > 0)
            heading.html(heading.html().replace("Comment", "Post"));

        $('.quick-comment-prompt span').each(function()
        {
            $(this).html($(this).html().replace("comment", "post"));
        });

        // keep checking, in case a new comment is added to the page (does not refresh)
        setTimeout(renameComments, 1000);
    }

    // may need to do this under a timer....
    renameComments();

    //
    // I need to disabled the 'c' Create/Add page shortcut key
    //
    // physically remove these buttons 'create-page-button', 'quick-create-page-button' from the page
    function removeElement(id) {
        var elem = document.getElementById(id);
        return elem.parentNode.removeChild(elem);
    }
    removeElement("create-page-button");
    removeElement("quick-create-page-button");

    // attach select2 to our search
    function attachSearch()
    {
        //let searchUrl = `${AJS.Meta.get("context-path")}/rest/api/content/search`;
        let searchUrl = `${AJS.Meta.get("context-path")}/rest/searchv3/1.0/cqlSearch`;
        let query = `SPACE=${AJS.Meta.get("space-key")} AND TYPE IN ("page", "comment") AND LABEL = "${AJS.Meta.get("page-id")}" AND TEXT ~ `;
        //query = `SPACE="${AJS.Meta.get("space-key")}" AND ANCESTOR=${AJS.Meta.get("page-id")} AND TYPE IN ("page", "comment") AND SITESEARCH ~ `;
        let userPrompt = "Search for text";

        AJS.$('#easy-forums-search').auiSelect2(
        {
            ajax: {
                url: searchUrl,
                dataType: 'json',
                contentType: 'application/json',
                type: 'GET',
                quietMillis: 500,
                data: function (params)
                {
                    searchTerm = params;
                    if(params.length > 2)
                    {
                        return {
                            cql: query + params,
                        }
                    }
                    return {
                        cql: "CONTAINER = 123",   // dummy query to return zero result
                    }
                },
                results: function (data)
                {
                    // data = {"totalSize":1,"result":[{"id":"4489220","type":"user","title":"Tom Grow","wikiLink":"[~alan]","createdDate":{"friendly":"yesterday at 9:41 PM","date":"2017-07-07T21:41:34+1000"},"creator":{"links":[{"href":"http://beast-pc:1990/confluence/rest/prototype/1/user/non-system/admin","rel":"self"}],"avatarUrl":"/confluence/images/icons/profilepics/default.png","displayableEmail":"admin@example.com","anonymous":false,"name":"admin","displayName":"admin"},"lastModifier":{"links":[{"href":"http://beast-pc:1990/confluence/rest/prototype/1/user/non-system/admin","rel":"self"}],"avatarUrl":"/confluence/images/icons/profilepics/default.png","displayableEmail":"admin@example.com","anonymous":false,"name":"admin","displayName":"admin"},"username":"alan","userKey":"4028818d5d1ccce6015d1cdae8ea0003","thumbnailLink":{"href":"/confluence/images/icons/profilepics/default.png","type":"image/png","rel":"thumbnail"},"link":[{"href":"http://BEAST-PC:1990/confluence/display/~alan","type":"text/html","rel":"alternate"},{"href":"http://BEAST-PC:1990/confluence/spaces/flyingpdf/pdfpageexport.action?pageId=4489220","type":"application/pdf","rel":"alternate"},{"href":"http://beast-pc:1990/confluence/rest/prototype/1/content/4489220","rel":"self"}]}],"group":[]}
                    // parse the results into the format expected by Select2
                    var results = [];



                    if(data.results.length > 0)
                    {
                        $.each(data.results, function(index, item)
                        {
                            results.push({id: item.url, text: item.title});
                            //if(item.type == "group")
                            // {
                            //    results.push({id: "group", text: item.name});
                            //}
                            //else if (item.type == "user")
                            //{
                            //    results.push({id: item.userKey, text: item.title});
                            //}
                        });
                    }

                    return {
                        results: results
                    };
                }
            },
            placeholder: userPrompt,
        }).on("select2-close", function (e) {
            // todo: open the selected page...
            setTimeout(function()
            {
                $('.select2-container-active').removeClass('select2-container-active');
                $(':focus').blur();
            }, 1);
        });
    }
    //attachSearch();
});


