/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.servlets;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.ForumDataService;
import net.kentcom.easyforums.ForumUtilities;
import net.kentcom.easyforums.StatusType;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetStatusServlet
extends HttpServlet {
    private final ForumDataService forumDataService_m;
    private final PageManager pageManager_m;
    private final StatusType statusType_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final ForumUtilities forumUtilities_m;
    private final VelocityHelperService velocityHelperService_m;
    private final AppConfigSettings appConfigSettings_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    @Inject
    public SetStatusServlet(@ComponentImport VelocityHelperService velocityHelperService, @ComponentImport PageManager pageManager, ConfluenceUtilities confluenceUtilities, ForumUtilities forumUtilities, ForumDataService forumDataService, AppConfigSettings appConfigSettings, StatusType statusType) {
        this.forumDataService_m = forumDataService;
        this.statusType_m = statusType;
        this.pageManager_m = pageManager;
        this.confluenceUtilities_m = confluenceUtilities;
        this.velocityHelperService_m = velocityHelperService;
        this.forumUtilities_m = forumUtilities;
        this.appConfigSettings_m = appConfigSettings;
    }

    @LicensedOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(503);
            return;
        }
        String pageId = request.getParameter("pageId");
        String value = request.getParameter("value");
        String action = request.getParameter("action");
        String macro = request.getParameter("macro");
        String spaceKey = request.getParameter("spaceKey");
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        boolean isUserAdministrator = this.confluenceUtilities_m.isUserAdministrator(user, spaceKey);
        boolean isUserModerator = this.forumUtilities_m.isUserModerator(user, pageId);
        Long max = this.appConfigSettings_m.getLong(ForumConstants.maxTableItems_m);
        if (action.equals("ToggleHidden")) {
            this.logger_m.info("pageId: " + pageId + " Action: " + action + " value: " + value);
            Page page = (Page)this.pageManager_m.getById(Long.parseLong(pageId));
            boolean showHiddenContent = value != null && value.equals("true");
            this.forumDataService_m.allowHiddenAccess(pageId, user.getKey().getStringValue(), showHiddenContent);
            Map context = MacroUtils.defaultVelocityContext();
            if (macro.equals("forum-home")) {
                context.put("tableHeadings", this.forumUtilities_m.addForumHomeColumnHeadings());
                context.put("class", "ef-summary-heading");
                context.put("tableData", this.forumUtilities_m.createListOfForums(page, user, isUserAdministrator, isUserModerator, max, showHiddenContent));
            } else {
                context.put("tableHeadings", this.forumUtilities_m.addForumColumnHeadings());
                context.put("class", "ef-forum-heading");
                context.put("tableData", this.forumUtilities_m.createListOfTopics(page, user, isUserAdministrator, isUserModerator, max, showHiddenContent));
            }
            String result = this.velocityHelperService_m.getRenderedTemplate("templates/easy-forums/page-list.vm", context);
            response.getWriter().write(result);
        } else {
            int statusId = Integer.parseInt(action);
            this.logger_m.info("pageId: {} Action: {} statusId: {}", new Object[]{pageId, action, statusId});
            this.forumDataService_m.setContentStatus(pageId, statusId);
            action = this.statusType_m.getValue(statusId);
            response.getWriter().write(action);
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setStatus(200);
    }

    @LicensedOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject json = new JSONObject();
        JSONArray statusList = new JSONArray();
        Set<Map.Entry<Integer, String>> statusEntries = this.statusType_m.getValues();
        for (Map.Entry<Integer, String> entry : statusEntries) {
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)entry.getKey());
            obj.put("text", (Object)entry.getValue());
            statusList.put((Object)obj);
        }
        json.put("results", (Object)statusList);
        response.setContentType("application/json; charset=UTF-8");
        response.getWriter().write(json.toString());
        response.setStatus(200);
    }
}

