/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.servlets;

import com.atlassian.annotations.security.LicensedOnly;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.ForumDataService;
import net.kentcom.easyforums.ForumUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetModeratorsServlet
extends HttpServlet {
    private final ForumDataService forumDataService_m;
    private final ForumUtilities forumUtilities_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    @Inject
    public SetModeratorsServlet(ConfluenceUtilities confluenceUtilities, ForumUtilities forumUtilities, ForumDataService forumDataService) {
        this.forumDataService_m = forumDataService;
        this.forumUtilities_m = forumUtilities;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    @LicensedOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(503);
            return;
        }
        String pageId = request.getParameter("pageId");
        String action = request.getParameter("action");
        String userKey = request.getParameter("userKey");
        this.logger_m.info("pageId: {} Action: {} UserKey: {}", new Object[]{pageId, action, userKey});
        if (!userKey.isEmpty()) {
            if (action.equals("add")) {
                this.forumDataService_m.addForumModerator(pageId, userKey);
            } else if (action.equals("remove")) {
                this.forumDataService_m.removeForumModerator(pageId, userKey);
            }
            response.setContentType("text/html; charset=UTF-8");
            response.getWriter().write(this.forumUtilities_m.renderForumModerators(pageId));
            response.setStatus(200);
        } else {
            response.setStatus(406);
        }
    }
}

