/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.FileUtils;
import net.kentcom.common.LicenseCheck;
import net.kentcom.easyforums.EasyForums;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.ForumDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Path(value="/admin")
public class AdminPageRest {
    private final Logger logger_m = LoggerFactory.getLogger(AdminPageRest.class);
    private final UserManager userManager_m;
    private final AppConfigSettings appConfigSettings_m;
    private final ForumDataService forumDataService_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final GlobalSettingsManager settingsManager_m;
    private final EasyForums easyForums_m;
    private final I18nResolver i18nResolver_m;
    private final LicenseCheck licenseCheck_m;
    private final String tempFolder_m;

    @Inject
    public AdminPageRest(@ComponentImport UserManager userManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport GlobalSettingsManager settingsManager, @ComponentImport I18nResolver i18nResolver, AppConfigSettings appConfigSettings, ForumDataService forumDataService, ConfluenceUtilities confluenceUtilities, EasyForums easyForums, LicenseCheck licenseCheck) {
        this.userManager_m = userManager;
        this.forumDataService_m = forumDataService;
        this.appConfigSettings_m = appConfigSettings;
        this.confluenceUtilities_m = confluenceUtilities;
        this.settingsManager_m = settingsManager;
        this.i18nResolver_m = i18nResolver;
        this.licenseCheck_m = licenseCheck;
        this.easyForums_m = easyForums;
        this.tempFolder_m = bootstrapManager.getApplicationConfig().getApplicationHome() + "/temp/";
    }

    @GET
    @AdminOnly
    @Path(value="/export/ao")
    @Produces(value={"text/html"})
    public Response exportData() {
        String result;
        block7: {
            if (!this.userManager_m.isAdmin(AuthenticatedUserThreadLocal.get().getKey())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (!this.licenseCheck_m.isLicenseOK()) {
                this.logger_m.info("Easy Forums: License Invalid");
                return Response.status((int)402).build();
            }
            result = "";
            File directory = new File(this.tempFolder_m);
            if (!directory.exists()) {
                directory.mkdir();
            }
            PrintWriter csvFile = null;
            try {
                String topicsFileName = this.tempFolder_m + "EF_Topics.csv";
                String forumsFileName = this.tempFolder_m + "EF_Forums.csv";
                String usersFileName = this.tempFolder_m + "EF_Users.csv";
                String bandanaFileName = this.tempFolder_m + "EF_Bandana.csv";
                String zipFileName = this.tempFolder_m + "EF_Export.zip";
                this.logger_m.info("Start export of EF_Forums table");
                File file = new File(forumsFileName);
                csvFile = new PrintWriter(file.getAbsoluteFile());
                this.forumDataService_m.exportForums(csvFile);
                csvFile.close();
                this.logger_m.info("Start export of EF_Topics table");
                file = new File(topicsFileName);
                csvFile = new PrintWriter(file.getAbsoluteFile());
                this.forumDataService_m.exportTopics(csvFile);
                csvFile.close();
                this.logger_m.info("Start export of EF_Users table");
                file = new File(usersFileName);
                csvFile = new PrintWriter(file.getAbsoluteFile());
                this.forumDataService_m.exportUsers(csvFile);
                csvFile.close();
                this.logger_m.info("Start export of Bandana table");
                file = new File(bandanaFileName);
                csvFile = new PrintWriter(file.getAbsoluteFile());
                this.easyForums_m.exportBandanaData(csvFile);
                csvFile.close();
                if (FileUtils.zipFiles(zipFileName, forumsFileName, topicsFileName, usersFileName, bandanaFileName) != null) {
                    Date now = new Date();
                    result = String.format("%s <a href=\"%s/rest/easyforums/1.0/admin/download/EF_Export.zip\" download=\"EF_Export-%tY%tm%td-%tH%tM%tS.zip\">%s</a>", this.i18nResolver_m.getText("net.kentcom.easy-forums.admin.export.finished"), this.settingsManager_m.getGlobalSettings().getBaseUrl(), now, now, now, now, now, now, this.i18nResolver_m.getText("net.kentcom.easy-forums.here"));
                } else {
                    result = this.i18nResolver_m.getText("net.kentcom.easy-forums.admin.export.error");
                }
                this.logger_m.info("Export finished");
            }
            catch (Exception e) {
                this.logger_m.error(e.toString());
                this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
                if (csvFile == null) break block7;
                csvFile.close();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @GET
    @AdminOnly
    @Path(value="/download/{filename}")
    @Produces(value={"application/octet-stream"})
    public Response downloadFile(@PathParam(value="filename") String filename) {
        if (!this.userManager_m.isAdmin(AuthenticatedUserThreadLocal.get().getKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.logger_m.info("Download file: " + filename);
        String zipFileName = this.tempFolder_m + filename;
        File file = new File(zipFileName);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)file).build();
    }

    @POST
    @AdminOnly
    @Path(value="upgrade")
    public Response startManualUpgrade() {
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        if (!this.userManager_m.isAdmin(AuthenticatedUserThreadLocal.get().getKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.appConfigSettings_m.setString(ForumConstants.upgradeStatus_m, ForumConstants.UpgradeStatus.IN_PROGRESS.name());
        this.forumDataService_m.deleteAllData();
        boolean result = this.easyForums_m.migrateBandanaToAO();
        if (result) {
            this.appConfigSettings_m.setString(ForumConstants.upgradeStatus_m, ForumConstants.UpgradeStatus.COMPLETE.name());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Upgrade finished successfully").build();
        }
        this.appConfigSettings_m.setString(ForumConstants.upgradeStatus_m, ForumConstants.UpgradeStatus.FAILED.name());
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Upgrade failed, please refer to Confluence log file for errors").build();
    }
}

