/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.spring.container.ContainerManager;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedType {
    protected final BandanaManager bandanaManager_m;
    protected final BandanaContext bandanaContext_m;
    protected Integer lastID_m = 0;
    public Map<Integer, String> typeValues_m = new TreeMap<Integer, String>();
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());
    private PluginSettings pluginSettings_m = null;

    public IndexedType(PluginSettingsFactory pluginSettingsFactory) {
        this.bandanaManager_m = (BandanaManager)ContainerManager.getComponent((String)"bandanaManager");
        this.bandanaContext_m = new ConfluenceBandanaContext("EF-" + this.getClass().getName());
        this.logger_m.info("Bandana Context: EF-" + this.getClass().getName());
        LicenseCheck licenseCheck = LicenseCheck.getInstance();
        this.pluginSettings_m = pluginSettingsFactory.createSettingsForKey(licenseCheck.getPluginKey());
        this.LoadValues();
    }

    private void LoadValues() {
        String tempMap;
        boolean migrate = false;
        for (String key : this.bandanaManager_m.getKeys(this.bandanaContext_m)) {
            int ID = Integer.parseInt(key);
            this.typeValues_m.put(ID, (String)this.bandanaManager_m.getValue(this.bandanaContext_m, key));
            this.bandanaManager_m.removeValue(this.bandanaContext_m, key);
            this.lastID_m = Math.max(ID, this.lastID_m);
            migrate = true;
        }
        if (migrate) {
            this.pluginSettings_m.put(this.getClass().getName(), (Object)MapUtil.mapToString(this.typeValues_m));
        }
        if ((tempMap = (String)this.pluginSettings_m.get(this.getClass().getName())) != null) {
            Map<Integer, String> map = MapUtil.stringToISMap(tempMap);
            this.typeValues_m = new TreeMap<Integer, String>(map);
        }
    }

    protected boolean addSystemValue(Integer id, String newValue) {
        if (this.typeValues_m.containsValue(newValue)) {
            return false;
        }
        if ((long)id.intValue() > 0L) {
            return false;
        }
        this.typeValues_m.put(id, newValue);
        this.pluginSettings_m.put(this.getClass().getName(), (Object)MapUtil.mapToString(this.typeValues_m));
        return true;
    }

    public Integer addValue(String newValue) {
        if (this.typeValues_m.containsValue(newValue) || newValue.equals("null")) {
            return 0;
        }
        Integer n = this.lastID_m;
        this.lastID_m = this.lastID_m + 1;
        this.typeValues_m.put(this.lastID_m, newValue);
        this.pluginSettings_m.put(this.getClass().getName(), (Object)MapUtil.mapToString(this.typeValues_m));
        return this.lastID_m;
    }

    public boolean renameValue(String oldValue, String newValue) {
        Integer ID;
        if (this.typeValues_m.containsValue(oldValue) && (ID = MapUtil.getKeyByValue(this.typeValues_m, oldValue)) != null && (long)ID.intValue() > 0L) {
            this.typeValues_m.remove(ID);
            this.typeValues_m.put(ID, newValue);
            this.pluginSettings_m.put(this.getClass().getName(), (Object)MapUtil.mapToString(this.typeValues_m));
            return true;
        }
        return false;
    }

    public boolean deleteValue(String value) {
        Integer ID;
        if (this.typeValues_m.containsValue(value) && (ID = MapUtil.getKeyByValue(this.typeValues_m, value)) != null && (long)ID.intValue() > 0L) {
            this.typeValues_m.remove(ID);
            this.pluginSettings_m.put(this.getClass().getName(), (Object)MapUtil.mapToString(this.typeValues_m));
            return true;
        }
        return false;
    }

    public Set<Map.Entry<Integer, String>> getValues() {
        return this.typeValues_m.entrySet();
    }

    public Integer getKey(String value) {
        if (this.typeValues_m.containsValue(value)) {
            return MapUtil.getKeyByValue(this.typeValues_m, value);
        }
        return null;
    }

    public String getValue(Integer key) {
        if (this.typeValues_m.containsKey(key)) {
            return this.typeValues_m.get(key);
        }
        return null;
    }
}

