/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.HtmlTableEntry;
import net.kentcom.common.MapUtil;
import net.kentcom.common.SortedArrayList;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.ForumDataService;
import net.kentcom.easyforums.StatusType;
import net.kentcom.easyforums.TableColumnHeadings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ForumUtilities {
    private final PageManager pageManager_m;
    private final CommentManager commentManager_m;
    private final UserAccessor userAccessor_m;
    private final StatusType statusType_m;
    private final GlobalSettingsManager settingsManager_m;
    private final AppConfigSettings appConfigSetting_m;
    private final ForumDataService forumDataService_m;
    private final NotificationManager notificationManager_m;
    private final I18nResolver i18nResolver_m;
    private final XhtmlContent xhtmlContent_m;
    private final PageTemplateManager pageTemplateManager_m;
    private final PermissionManager permissionManager_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final VelocityHelperService velocityHelperService_m;
    private final Logger logger_m = LoggerFactory.getLogger(ForumUtilities.class);
    private SummaryMap summaryHeadings_m = null;
    private ForumMap forumHeadings_m = null;

    public SummaryMap getSummaryMap() {
        if (this.summaryHeadings_m == null) {
            this.summaryHeadings_m = this.createSummaryMap();
        }
        return this.summaryHeadings_m;
    }

    public ForumMap getForumMap() {
        if (this.forumHeadings_m == null) {
            this.forumHeadings_m = this.createForumMap();
        }
        return this.forumHeadings_m;
    }

    @Inject
    public ForumUtilities(@ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport CommentManager commentManager, @ComponentImport NotificationManager notificationManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport GlobalSettingsManager settingsManager, @ComponentImport PageTemplateManager pageTemplateManager, @ComponentImport PermissionManager permissionManager, @ComponentImport VelocityHelperService velocityHelperService, AppConfigSettings appConfigSetting, ForumDataService forumDataService, StatusType statusType, ConfluenceUtilities confluenceUtilities) {
        this.userAccessor_m = userAccessor;
        this.notificationManager_m = notificationManager;
        this.forumDataService_m = forumDataService;
        this.i18nResolver_m = i18nResolver;
        this.xhtmlContent_m = xhtmlContent;
        this.pageTemplateManager_m = pageTemplateManager;
        this.appConfigSetting_m = appConfigSetting;
        this.confluenceUtilities_m = confluenceUtilities;
        this.settingsManager_m = settingsManager;
        this.permissionManager_m = permissionManager;
        this.statusType_m = statusType;
        this.pageManager_m = pageManager;
        this.commentManager_m = commentManager;
        this.velocityHelperService_m = velocityHelperService;
    }

    private SummaryMap createSummaryMap() {
        SummaryMap myMap = new SummaryMap();
        for (ForumConstants.SummaryColumns col : ForumConstants.SummaryColumns.values()) {
            String colName = col.name();
            this.appConfigSetting_m.addBoolean("EF-Summary-" + colName, true);
            myMap.put(col, new ColumnAttributes(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.column." + colName), this.appConfigSetting_m.getBoolean("EF-Summary-" + colName)));
        }
        return myMap;
    }

    private ForumMap createForumMap() {
        ForumMap myMap = new ForumMap();
        for (ForumConstants.ForumColumns col : ForumConstants.ForumColumns.values()) {
            String colName = col.name();
            this.appConfigSetting_m.addBoolean("EF-Forum-" + colName, true);
            myMap.put(col, new ColumnAttributes(this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.column." + colName), this.appConfigSetting_m.getBoolean("EF-Forum-" + colName)));
        }
        return myMap;
    }

    public void updateForumMap(ForumConstants.ForumColumns column, Boolean visible) {
        ForumMap forumMap = this.getForumMap();
        ColumnAttributes attr = (ColumnAttributes)forumMap.get((Object)column);
        attr.setVisible(visible);
        forumMap.put(column, attr);
        this.appConfigSetting_m.setBoolean("EF-Forum-" + column.name(), visible);
    }

    public void updateSummaryMap(ForumConstants.SummaryColumns column, Boolean visible) {
        SummaryMap summaryMap = this.getSummaryMap();
        ColumnAttributes attr = (ColumnAttributes)summaryMap.get((Object)column);
        attr.setVisible(visible);
        summaryMap.put(column, attr);
        this.appConfigSetting_m.setBoolean("EF-Summary-" + column.name(), visible);
    }

    public String getWatchLink(Page page, ConfluenceUser user) {
        try {
            List allWatches = this.notificationManager_m.getNotificationsByContent((ContentEntityObject)page);
            String isWatching = this.notificationManager_m.isWatchingContent((User)user, (ContentEntityObject)page) ? this.i18nResolver_m.getText("net.kentcom.easy-forums.watching.yes") : this.i18nResolver_m.getText("net.kentcom.easy-forums.watching.no");
            Map context = MacroUtils.defaultVelocityContext();
            context.put("isWatching", isWatching);
            context.put("pageId", page.getIdAsString());
            context.put("userKey", user.getKey());
            context.put("numWatches", allWatches.size());
            return this.velocityHelperService_m.getRenderedTemplate("/templates/easy-forums/watch-link.vm", context);
        }
        catch (Exception e) {
            return this.i18nResolver_m.getText("net.kentcom.easy-forums.watching.anonymous");
        }
    }

    public boolean isUserModerator(ConfluenceUser user, String pageId) {
        try {
            boolean forumModerator = this.forumDataService_m.isForumModerator(pageId, user.getKey().getStringValue());
            return this.confluenceUtilities_m.isUserInGroup(user, ForumConstants.moderatorGroupName_m) || forumModerator;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String renderLiveSearchBox(String searchPrompt, ConversionContext conversionContext) {
        String text = "<div class=\"columnLayout two-equal\" data-layout=\"two-equal\">  <div class=\"cell normal\" data-type=\"normal\">    <div class=\"innerCell ef-no-scrollbars\">      <h2  class=\"ef-text-right\">" + searchPrompt + "      </h2>    </div>  </div>  <div class=\"cell normal\" data-type=\"normal\">    <div id=\"ef-search-macro\" class=\"innerCell\">      <ac:structured-macro ac:name=\"livesearch\" ac:schema-version=\"1\">        <ac:parameter ac:name=\"additional\">none</ac:parameter>        <ac:parameter ac:name=\"type\">comment</ac:parameter>        <ac:parameter ac:name=\"type\">page</ac:parameter>        <ac:parameter ac:name=\"spaceKey\"><ri:space ri:space-key=\"" + conversionContext.getSpaceKey() + "\" /></ac:parameter>      </ac:structured-macro>    </div>  </div></div>";
        try {
            return this.xhtmlContent_m.convertStorageToView(text, conversionContext);
        }
        catch (Exception e) {
            this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            return "ERROR: " + e.toString();
        }
    }

    public String renderPageTreeSearchBox(String searchPrompt, ConversionContext conversionContext) {
        String text = "<div class=\"columnLayout two-equal\" data-layout=\"two-equal\">  <div class=\"cell normal\" data-type=\"normal\">    <div class=\"innerCell ef-no-scrollbars\">      <h2  class=\"ef-text-right\">" + searchPrompt + "      </h2>    </div>  </div>  <div class=\"cell normal\" data-type=\"normal\">    <div class=\"innerCell\">      <input class=\"aui text easy-forums-search\" type=\"text\" id=\"easy-forums-search\"/>    </div>  </div></div>";
        try {
            return this.xhtmlContent_m.convertStorageToView(text, conversionContext);
        }
        catch (Exception e) {
            this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            return "ERROR: " + e.toString();
        }
    }

    public String hidePageElements(boolean hideEditButton, boolean hideComments, boolean readOnlyComments, boolean hideLabels, boolean hideActionMenu, boolean hidePageMetadata) {
        boolean showSidebar;
        try {
            showSidebar = this.appConfigSetting_m.getBoolean(ForumConstants.showSidebar_m);
        }
        catch (Exception e) {
            showSidebar = false;
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("hideSidebar", !showSidebar);
        context.put("hideEditButton", hideEditButton);
        context.put("hideActionMenu", hideActionMenu);
        context.put("hideComments", hideComments);
        context.put("readOnlyComments", readOnlyComments);
        context.put("hidePageMetadata", hidePageMetadata);
        context.put("hideLabels", hideLabels);
        return this.velocityHelperService_m.getRenderedTemplate("templates/easy-forums/hide-elements-style.vm", context);
    }

    public String renderForumModerators(String pageId) {
        Set<String> userKeys = this.forumDataService_m.getForumModerators(pageId);
        Long max = this.appConfigSetting_m.getLong(ForumConstants.maxForumModerators_m);
        String template = "<span class=\"aui-label aui-label-closeable\" key=\"@key\">@name\n<span tabindex=\"0\" title=\"" + this.i18nResolver_m.getText("net.kentcom.easy-forums.delete") + "\" class=\"aui-icon aui-icon-close ef-remove-moderator\" data-key=\"@key\" ></span>\n</span>";
        StringBuilder builder = new StringBuilder();
        for (String userKey : userKeys) {
            ConfluenceUser user = this.userAccessor_m.getUserByKey(new UserKey(userKey));
            String html = template.replaceAll("@key", userKey);
            html = html.replaceAll("@name", user.getFullName());
            builder.append(html);
        }
        if ((long)userKeys.size() >= max) {
            builder.append("<i>");
            builder.append(this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.max.configured"));
            builder.append("</i>");
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String addCreateNewButton(String buttonName, String templateName, ConversionContext conversionContext, boolean forForum) {
        StringBuilder test = new StringBuilder();
        String customTemplate = this.appConfigSetting_m.getString(ForumConstants.forumTemplate_m);
        test.append("<ac:structured-macro ac:name=\"create-from-template\">\n");
        test.append("<ac:parameter ac:name=\"buttonLabel\">");
        test.append(buttonName);
        test.append("</ac:parameter>\n");
        if (forForum && !Objects.equals(customTemplate, "EasyForums-Forum")) {
            PageTemplate pageTemplate = this.pageTemplateManager_m.getGlobalPageTemplate(customTemplate);
            if (pageTemplate == null) return "ERROR: Global template " + customTemplate + " not found";
            test.append("<ac:parameter ac:name=\"templateName\">");
            test.append(customTemplate);
            test.append("</ac:parameter>\n");
            test.append("<ac:parameter ac:name=\"templateId\">");
            test.append(pageTemplate.getId());
            test.append("</ac:parameter>\n");
        } else {
            test.append("<ac:parameter ac:name=\"blueprintModuleCompleteKey\">net.kentcom.easy-forums:");
            test.append(templateName);
            test.append("</ac:parameter>\n");
            test.append("<ac:parameter ac:name=\"templateName\">net.kentcom.easy-forums:");
            test.append(templateName);
            test.append("</ac:parameter>\n");
        }
        test.append("</ac:structured-macro>\n");
        try {
            return this.xhtmlContent_m.convertStorageToView(test.toString(), conversionContext);
        }
        catch (Exception e) {
            this.logger_m.error(e.toString());
            return "ERROR: " + e.getMessage();
        }
    }

    public List<TableColumnHeadings> addForumHomeColumnHeadings() {
        ArrayList<TableColumnHeadings> headers = new ArrayList<TableColumnHeadings>();
        SummaryMap summaryMap = this.getSummaryMap();
        for (ForumConstants.SummaryColumns column : ForumConstants.SummaryColumns.values()) {
            ColumnAttributes attr = (ColumnAttributes)summaryMap.get((Object)column);
            if (attr == null || !attr.isVisible().booleanValue()) continue;
            if (column == ForumConstants.SummaryColumns.SUBSCRIBE) {
                String baseUrl = this.settingsManager_m.getGlobalSettings().getBaseUrl();
                String infoUrl = baseUrl + "/download/resources/net.kentcom.easy-forums:easy-forums-resources/images/info.png";
                String name = "<abbr title=\"" + this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.subscribe") + "\">" + attr.Name() + "&nbsp;&nbsp;<img src=\"" + infoUrl + "\" style=\"padding-top:2px\" align=\"top\" width=\"15\" height=\"15\"></abbr>";
                headers.add(new TableColumnHeadings(name, attr.Name()));
                continue;
            }
            headers.add(new TableColumnHeadings(attr.Name(), attr.Name()));
        }
        return headers;
    }

    public List<List<String>> createListOfForums(Page parent, ConfluenceUser user, boolean isUserAdmin, boolean isUserModerator, Long max, boolean showHidden) {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        SortedArrayList<HtmlTableEntry> table = new SortedArrayList<HtmlTableEntry>();
        List forums = parent.getChildren();
        for (Page page : forums) {
            this.logger_m.debug("Found child page: {}", (Object)page.getTitle());
            if (!ForumConstants.isPageForum((Labelable)page)) continue;
            this.addForumToTable(page, table, user, isUserAdmin, isUserModerator, showHidden);
        }
        int count = 0;
        for (HtmlTableEntry entry : table) {
            data.add((List)entry.row_m);
            if ((long)(++count) < max) continue;
            break;
        }
        return data;
    }

    private void addForumToTable(Page forum, SortedArrayList<HtmlTableEntry> table, ConfluenceUser user, boolean isUserAdmin, boolean isUserModerator, boolean showHidden) {
        EnumMap<ForumConstants.SummaryColumns, String> data = new EnumMap<ForumConstants.SummaryColumns, String>(ForumConstants.SummaryColumns.class);
        EnumMap<ForumConstants.SummaryColumns, String> avatar = new EnumMap<ForumConstants.SummaryColumns, String>(ForumConstants.SummaryColumns.class);
        HtmlTableEntry entry = new HtmlTableEntry();
        List topics = forum.getChildren();
        int numTopics = 0;
        int numPosts = 0;
        Integer statusId = this.forumDataService_m.getContentStatus(forum.getIdAsString());
        String anonymous = this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous");
        boolean showAvatars = this.appConfigSetting_m.getBoolean(ForumConstants.showAvatar_m);
        String sort = this.appConfigSetting_m.getString(ForumConstants.defaultSortColumn_m);
        ForumConstants.SummaryColumns sortColumn = ForumConstants.SummaryColumns.LAST_POST;
        if (sort.toUpperCase().equals(ForumConstants.ForumColumns.NAME.name())) {
            sortColumn = ForumConstants.SummaryColumns.NAME;
        } else if (sort.toUpperCase().equals(ForumConstants.ForumColumns.STATUS.name())) {
            sortColumn = ForumConstants.SummaryColumns.STATUS;
        }
        this.logger_m.info("Processing " + forum.getTitle());
        this.logger_m.info("Hidden value {} and page status value {}", (Object)StatusType.Hidden, (Object)statusId);
        if (statusId != null && statusId == StatusType.Hidden && !showHidden) {
            this.logger_m.info("This forum is hidden - skipping");
            return;
        }
        if (this.permissionManager_m.hasPermission(user, Permission.VIEW, (Object)forum)) {
            for (Page topic : topics) {
                if (!ForumConstants.isPageTopic((Labelable)topic)) continue;
                List comments = topic.getComments();
                numPosts += comments.size() + 1;
                ++numTopics;
            }
            data.put(ForumConstants.SummaryColumns.LAST_POST, "");
            data.put(ForumConstants.SummaryColumns.BY_USER, "");
            avatar.put(ForumConstants.SummaryColumns.BY_USER, "");
            entry.id_m = "0";
            Long ceoId = this.forumDataService_m.getLastUpdateId(forum.getIdAsString());
            if (ceoId != null) {
                ContentEntityObject ceo = this.pageManager_m.getById(ceoId.longValue());
                if (ceo == null) {
                    ceo = this.commentManager_m.getComment(ceoId.longValue());
                }
                if (ceo != null) {
                    Date lastModDate = ceo.getLastModificationDate();
                    data.put(ForumConstants.SummaryColumns.LAST_POST, ForumConstants.dateFormat_m.format(lastModDate));
                    try {
                        data.put(ForumConstants.SummaryColumns.BY_USER, ceo.getLastModifier().getFullName());
                    }
                    catch (Exception e) {
                        data.put(ForumConstants.SummaryColumns.BY_USER, anonymous);
                    }
                    avatar.put(ForumConstants.SummaryColumns.BY_USER, this.confluenceUtilities_m.getImageUrlString(ceo.getLastModifier(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")) + "  ");
                    entry.id_m = ForumConstants.sortFormat_m.format(lastModDate);
                }
            }
            data.put(ForumConstants.SummaryColumns.STATUS, this.getStatusLink(forum, statusId, false, isUserModerator || isUserAdmin));
            data.put(ForumConstants.SummaryColumns.NAME, this.confluenceUtilities_m.getHtmlLink((ContentEntityObject)forum));
            data.put(ForumConstants.SummaryColumns.NUM_TOPICS, Integer.toString(numTopics));
            data.put(ForumConstants.SummaryColumns.NUM_POSTS, Integer.toString(numPosts));
            data.put(ForumConstants.SummaryColumns.TOP_CONTRIBUTORS, this.getTopContributors(forum, showAvatars));
            data.put(ForumConstants.SummaryColumns.SUBSCRIBE, this.getWatchLink(forum, user));
            entry.row_m = this.addForumDataToRow(data, avatar, showAvatars);
            if (sortColumn == ForumConstants.SummaryColumns.NAME) {
                entry.id_m = forum.getTitle();
            } else if (sortColumn == ForumConstants.SummaryColumns.STATUS) {
                entry.id_m = this.statusType_m.getValue(statusId);
            }
            table.insertSorted(entry);
        } else {
            this.logger_m.info("User does not have View permissions to this page {}", (Object)forum.getTitle());
        }
    }

    private List<String> addForumDataToRow(Map<ForumConstants.SummaryColumns, String> data, Map<ForumConstants.SummaryColumns, String> avatar, boolean showAvatars) {
        ArrayList<String> row = new ArrayList<String>();
        SummaryMap summaryMap = this.getSummaryMap();
        for (ForumConstants.SummaryColumns column : ForumConstants.SummaryColumns.values()) {
            ColumnAttributes attr = (ColumnAttributes)summaryMap.get((Object)column);
            if (!attr.isVisible().booleanValue()) continue;
            String cell = "";
            if (column == ForumConstants.SummaryColumns.BY_USER && showAvatars && avatar != null) {
                cell = avatar.get((Object)column);
            }
            if (data != null) {
                cell = cell + data.get((Object)column);
            }
            row.add(cell);
        }
        return row;
    }

    private String getTopContributors(Page forum, boolean showAvatars) {
        StringBuilder builder = new StringBuilder();
        Map<ConfluenceUser, Integer> topContributors = new HashMap();
        for (Page topic : forum.getChildren()) {
            ConfluenceUser creator = topic.getCreator();
            if (creator == null) continue;
            Integer freq = (Integer)topContributors.get(creator);
            topContributors.put(creator, freq == null ? 1 : freq + 1);
            for (Comment comment : topic.getComments()) {
                creator = comment.getCreator();
                if (creator == null) continue;
                freq = (Integer)topContributors.get(creator);
                topContributors.put(creator, freq == null ? 1 : freq + 1);
            }
        }
        int maxSize = 5;
        int count = 0;
        topContributors = MapUtil.sortByValue(topContributors, false);
        for (Map.Entry entry : topContributors.entrySet()) {
            if (count > 0) {
                if (showAvatars) {
                    builder.append("  ");
                } else {
                    builder.append(", ");
                }
            }
            if (showAvatars) {
                builder.append(this.confluenceUtilities_m.getImageUrlString((ConfluenceUser)entry.getKey(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")));
            } else {
                builder.append(((ConfluenceUser)entry.getKey()).getFullName());
            }
            if (count++ != maxSize) continue;
            break;
        }
        return builder.toString();
    }

    public List<TableColumnHeadings> addForumColumnHeadings() {
        ArrayList<TableColumnHeadings> headers = new ArrayList<TableColumnHeadings>();
        ForumMap forumMap = this.getForumMap();
        for (ForumConstants.ForumColumns column : ForumConstants.ForumColumns.values()) {
            ColumnAttributes attr = (ColumnAttributes)forumMap.get((Object)column);
            if (!attr.isVisible().booleanValue()) continue;
            if (column == ForumConstants.ForumColumns.SUBSCRIBE) {
                String baseUrl = this.settingsManager_m.getGlobalSettings().getBaseUrl();
                String infoUrl = baseUrl + "/download/resources/net.kentcom.easy-forums:easy-forums-resources/images/info.png";
                String name = "<abbr title=\"" + this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.subscribe") + "\">" + attr.Name() + "&nbsp;&nbsp;<img src=\"" + infoUrl + "\" style=\"padding-top:2px\" align=\"top\" width=\"15\" height=\"15\"></abbr>";
                headers.add(new TableColumnHeadings(name, attr.Name()));
                continue;
            }
            headers.add(new TableColumnHeadings(attr.Name(), attr.Name()));
        }
        return headers;
    }

    public List<List<String>> createListOfTopics(Page forum, ConfluenceUser user, boolean isUserAdmin, boolean isUserModerator, Long max, boolean showHidden) {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        SortedArrayList<HtmlTableEntry> table = new SortedArrayList<HtmlTableEntry>();
        List topics = forum.getChildren();
        Integer forumStatus = this.forumDataService_m.getContentStatus(forum.getIdAsString());
        Boolean showAvatars = this.appConfigSetting_m.getBoolean(ForumConstants.showAvatar_m);
        if (topics.isEmpty()) {
            HtmlTableEntry entry = new HtmlTableEntry();
            entry.row_m = this.addTopicDataToRow(null, null, showAvatars);
            entry.id_m = "0";
            table.insertSorted(entry);
        } else {
            for (Page topic : topics) {
                if (!ForumConstants.isPageTopic((Labelable)topic)) continue;
                this.addTopicToTable(topic, table, user, isUserAdmin, isUserModerator, showHidden, showAvatars, forumStatus);
            }
        }
        int count = 0;
        for (HtmlTableEntry entry : table) {
            this.logger_m.info(entry.row_m.toString());
            data.add((List)entry.row_m);
            if ((long)(++count) < max) continue;
            break;
        }
        return data;
    }

    private void addTopicToTable(Page topic, SortedArrayList<HtmlTableEntry> table, ConfluenceUser user, boolean isUserAdmin, boolean isUserModerator, boolean showHidden, boolean showAvatars, Integer forumStatus) {
        EnumMap<ForumConstants.ForumColumns, String> data = new EnumMap<ForumConstants.ForumColumns, String>(ForumConstants.ForumColumns.class);
        EnumMap<ForumConstants.ForumColumns, String> avatar = new EnumMap<ForumConstants.ForumColumns, String>(ForumConstants.ForumColumns.class);
        HtmlTableEntry entry = new HtmlTableEntry();
        String anonymous = this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous");
        List comments = topic.getComments();
        Integer statusId = this.forumDataService_m.getContentStatus(topic.getIdAsString());
        boolean statusOverridden = false;
        boolean sortAscending = false;
        String sort = this.appConfigSetting_m.getString(ForumConstants.defaultSortColumn_m);
        ForumConstants.ForumColumns sortColumn = ForumConstants.ForumColumns.LAST_POST;
        if (sort.toUpperCase().equals(ForumConstants.ForumColumns.NAME.name())) {
            sortColumn = ForumConstants.ForumColumns.NAME;
        } else if (sort.toUpperCase().equals(ForumConstants.ForumColumns.STATUS.name())) {
            sortColumn = ForumConstants.ForumColumns.STATUS;
        }
        this.logger_m.info("Processing " + topic.getTitle() + " Status: " + statusId);
        if (!(statusId != StatusType.Hidden || (isUserAdmin || isUserModerator) && showHidden)) {
            this.logger_m.info("This topic is hidden - skipping");
            return;
        }
        if (statusId != StatusType.Read_Only && forumStatus == StatusType.Read_Only) {
            statusId = StatusType.Read_Only;
            statusOverridden = true;
        }
        if (this.permissionManager_m.hasPermission(user, Permission.VIEW, (Object)topic)) {
            Long pageViews;
            entry.id_m = "0";
            data.put(ForumConstants.ForumColumns.LAST_POST, "");
            data.put(ForumConstants.ForumColumns.BY_USER, "");
            avatar.put(ForumConstants.ForumColumns.BY_USER, "");
            Long ceoId = this.forumDataService_m.getLastUpdateId(topic.getIdAsString());
            if (ceoId != null) {
                ContentEntityObject ceo = this.pageManager_m.getById(ceoId.longValue());
                if (ceo == null) {
                    ceo = this.commentManager_m.getComment(ceoId.longValue());
                }
                if (ceo != null) {
                    Date lastModDate = ceo.getLastModificationDate();
                    data.put(ForumConstants.ForumColumns.LAST_POST, ForumConstants.dateFormat_m.format(lastModDate));
                    try {
                        data.put(ForumConstants.ForumColumns.BY_USER, ceo.getLastModifier().getFullName());
                    }
                    catch (Exception e) {
                        data.put(ForumConstants.ForumColumns.BY_USER, anonymous);
                    }
                    avatar.put(ForumConstants.ForumColumns.BY_USER, this.confluenceUtilities_m.getImageUrlString(ceo.getLastModifier(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")) + "  ");
                    entry.id_m = ForumConstants.sortFormat_m.format(lastModDate);
                }
            }
            if ((pageViews = Long.valueOf(this.forumDataService_m.getViewCount(topic.getIdAsString()))) != null) {
                String viewStr = pageViews.toString();
                data.put(ForumConstants.ForumColumns.NUM_VIEWS, viewStr);
            } else {
                data.put(ForumConstants.ForumColumns.NUM_VIEWS, "0");
            }
            data.put(ForumConstants.ForumColumns.STATUS, this.getStatusLink(topic, statusId, statusOverridden, isUserModerator || isUserAdmin));
            data.put(ForumConstants.ForumColumns.NAME, this.confluenceUtilities_m.getHtmlLink((ContentEntityObject)topic));
            data.put(ForumConstants.ForumColumns.CREATED_ON, ForumConstants.dateFormat_m.format(topic.getCreationDate()));
            data.put(ForumConstants.ForumColumns.NUM_REPLIES, Integer.toString(comments.size()));
            data.put(ForumConstants.ForumColumns.SUBSCRIBE, this.getWatchLink(topic, user));
            avatar.put(ForumConstants.ForumColumns.AUTHOR, this.confluenceUtilities_m.getImageUrlString(topic.getCreator(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")) + "  ");
            try {
                data.put(ForumConstants.ForumColumns.AUTHOR, topic.getCreator().getFullName());
            }
            catch (NullPointerException e) {
                data.put(ForumConstants.ForumColumns.AUTHOR, anonymous);
            }
            entry.row_m = this.addTopicDataToRow(data, avatar, showAvatars);
            if (sortColumn == ForumConstants.ForumColumns.NAME) {
                entry.id_m = topic.getTitle();
                sortAscending = true;
            } else if (sortColumn == ForumConstants.ForumColumns.STATUS) {
                entry.id_m = this.statusType_m.getValue(statusId);
                sortAscending = true;
            }
            this.logger_m.info("Inserting into table: " + entry.row_m);
            this.logger_m.info("Inserting into table: " + (String)entry.id_m);
            table.insertSorted(entry, sortAscending);
            this.logger_m.info("Inserted OK");
        } else {
            this.logger_m.info("User does not have View permissions to this page " + topic.getTitle());
        }
        this.logger_m.info("Finished");
    }

    private List<String> addTopicDataToRow(Map<ForumConstants.ForumColumns, String> data, Map<ForumConstants.ForumColumns, String> avatar, boolean showAvatars) {
        ArrayList<String> row = new ArrayList<String>();
        ForumMap forumMap = this.getForumMap();
        for (ForumConstants.ForumColumns column : ForumConstants.ForumColumns.values()) {
            ColumnAttributes attr = (ColumnAttributes)forumMap.get((Object)column);
            if (!attr.isVisible().booleanValue()) continue;
            String cell = "";
            if ((column == ForumConstants.ForumColumns.AUTHOR || column == ForumConstants.ForumColumns.BY_USER) && showAvatars && avatar != null) {
                cell = avatar.get((Object)column);
            }
            if (data != null) {
                cell = cell + data.get((Object)column);
            }
            row.add(cell);
        }
        return row;
    }

    private String getStatusLink(Page topic, Integer statusId, Boolean statusOverridden, Boolean isModerator) {
        String statusStr;
        String linkText = statusStr = this.statusType_m.getValue(statusId);
        if (isModerator.booleanValue()) {
            if (statusOverridden.booleanValue()) {
                linkText = this.statusType_m.getValue(this.forumDataService_m.getContentStatus(topic.getIdAsString())) + " (" + this.i18nResolver_m.getText("net.kentcom.easy-forums.status.readonly") + ")";
            }
            return "<a class=\"setstatus\" href=\"#\" data-page-id=\"" + topic.getIdAsString() + "\" data-status=\"" + statusStr + "\">" + linkText + "</a>";
        }
        return statusStr;
    }

    public class SummaryMap
    extends HashMap<ForumConstants.SummaryColumns, ColumnAttributes> {
    }

    public class ForumMap
    extends HashMap<ForumConstants.ForumColumns, ColumnAttributes> {
    }

    public class ColumnAttributes {
        private String Name_m;
        private Boolean Visible_m;

        ColumnAttributes(String Name2, Boolean Visible) {
            this.Name_m = Name2;
            this.Visible_m = Visible;
        }

        public String Name() {
            return this.Name_m;
        }

        public Boolean isVisible() {
            return this.Visible_m;
        }

        public void setVisible(Boolean visible) {
            this.Visible_m = visible;
        }
    }
}

