/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.kentcom.easyforums.AO_Forums;
import net.kentcom.easyforums.AO_Topics;
import net.kentcom.easyforums.AO_Users;
import net.kentcom.easyforums.ForumDataService;
import net.kentcom.easyforums.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ForumDataServiceImpl
implements ForumDataService {
    private final ActiveObjects activeObjects_m;
    private static final Logger logger_m = LoggerFactory.getLogger(ForumDataServiceImpl.class);

    @Inject
    public ForumDataServiceImpl(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects_m = activeObjects;
    }

    @Override
    public void deleteAllData() {
        this.activeObjects_m.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                logger_m.error("Deleting Forums Data");
                ForumDataServiceImpl.this.activeObjects_m.deleteWithSQL(AO_Forums.class, "ID > ?", new Object[]{0});
                logger_m.error("Deleting Topics Data");
                ForumDataServiceImpl.this.activeObjects_m.deleteWithSQL(AO_Topics.class, "ID > ?", new Object[]{0});
                logger_m.error("Deleting Users Data");
                ForumDataServiceImpl.this.activeObjects_m.deleteWithSQL(AO_Users.class, "ID > ?", new Object[]{0});
                return null;
            }
        });
    }

    @Override
    public void incrementTopicViewCount(String pageId) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                AO_Topics[] data = (AO_Topics[])this.activeObjects_m.find(AO_Topics.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
                if (data.length == 0) {
                    DBParam primaryKey = new DBParam("PAGE_ID", (Object)pageId);
                    AO_Topics insert = (AO_Topics)this.activeObjects_m.create(AO_Topics.class, new DBParam[]{primaryKey});
                    insert.setViews(1L);
                    insert.save();
                } else {
                    data[0].setViews(data[0].getViews() + 1L);
                    data[0].save();
                }
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public long getViewCount(String pageId) {
        try {
            AO_Topics[] data = (AO_Topics[])this.activeObjects_m.find(AO_Topics.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
            if (data.length > 0) {
                return data[0].getViews();
            }
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
        }
        return 0L;
    }

    @Override
    public void setLastUpdateId(String pageId, Long updateId, boolean topic) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                if (topic) {
                    AO_Topics[] topics = (AO_Topics[])this.activeObjects_m.find(AO_Topics.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
                    if (topics.length == 0) {
                        DBParam primaryKey = new DBParam("PAGE_ID", (Object)pageId);
                        AO_Topics insert = (AO_Topics)this.activeObjects_m.create(AO_Topics.class, new DBParam[]{primaryKey});
                        insert.setViews(0L);
                        insert.setStatus(StatusType.Active);
                        insert.setLastUpdatedId(updateId);
                        insert.save();
                    } else {
                        topics[0].setLastUpdatedId(updateId);
                        topics[0].save();
                    }
                } else {
                    AO_Forums[] forums = (AO_Forums[])this.activeObjects_m.find(AO_Forums.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
                    if (forums.length == 0) {
                        DBParam primaryKey = new DBParam("PAGE_ID", (Object)pageId);
                        AO_Forums insert = (AO_Forums)this.activeObjects_m.create(AO_Forums.class, new DBParam[]{primaryKey});
                        insert.setLastUpdatedId(updateId);
                        insert.setStatus(StatusType.Active);
                        insert.save();
                    } else {
                        forums[0].setLastUpdatedId(updateId);
                        forums[0].save();
                    }
                }
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    @Nullable
    public Long getLastUpdateId(String pageId) {
        try {
            AO_Forums[] forums = (AO_Forums[])this.activeObjects_m.find(AO_Forums.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
            if (forums.length == 0) {
                AO_Topics[] topics = (AO_Topics[])this.activeObjects_m.find(AO_Topics.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
                if (topics.length == 0) {
                    return null;
                }
                return topics[0].getLastUpdatedId();
            }
            return forums[0].getLastUpdatedId();
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
            return null;
        }
    }

    private Set<String> getSetFromString(String text) {
        if (text != null) {
            return Arrays.stream(text.split(";")).filter(value -> !value.isEmpty()).collect(Collectors.toCollection(TreeSet::new));
        }
        return new TreeSet<String>();
    }

    @Override
    public Set<String> getForumModerators(String pageId) {
        try {
            AO_Users[] data = (AO_Users[])this.activeObjects_m.find(AO_Users.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
            if (data.length == 0) {
                return new TreeSet<String>();
            }
            TreeSet<String> moderators = new TreeSet<String>();
            for (AO_Users user : data) {
                if (!user.getIsModerator()) continue;
                moderators.add(user.getUserKey());
            }
            return moderators;
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
            return new TreeSet<String>();
        }
    }

    @Override
    public boolean isForumModerator(String pageId, String userKey) {
        try {
            String key = pageId + userKey;
            AO_Users[] data = (AO_Users[])this.activeObjects_m.find(AO_Users.class, Query.select().where("KEY = ?", new Object[]{key}));
            if (data.length == 0) {
                return false;
            }
            return data[0].getIsModerator();
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
            return false;
        }
    }

    @Override
    public void addForumModerator(String pageId, String userKey) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                String key = pageId + userKey;
                AO_Users[] data = (AO_Users[])this.activeObjects_m.find(AO_Users.class, Query.select().where("KEY = ?", new Object[]{key}));
                if (data.length == 0) {
                    DBParam primaryKey = new DBParam("KEY", (Object)key);
                    AO_Users insert = (AO_Users)this.activeObjects_m.create(AO_Users.class, new DBParam[]{primaryKey});
                    insert.setPageId(pageId);
                    insert.setUserKey(userKey);
                    insert.setIsModerator(true);
                    insert.setShowHiddenContent(false);
                    insert.save();
                } else {
                    data[0].setIsModerator(true);
                    data[0].save();
                }
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public void removeForumModerator(String pageId, String userKey) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                String key = pageId + userKey;
                AO_Users[] data = (AO_Users[])this.activeObjects_m.find(AO_Users.class, Query.select().where("KEY = ?", new Object[]{key}));
                if (data.length == 1) {
                    this.activeObjects_m.delete(new RawEntity[]{data[0]});
                }
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public void allowHiddenAccess(String pageId, String userKey, boolean allow) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                String key = pageId + userKey;
                AO_Users[] users = (AO_Users[])this.activeObjects_m.find(AO_Users.class, Query.select().where("KEY = ?", new Object[]{key}));
                if (users.length == 0) {
                    if (allow) {
                        DBParam primaryKey = new DBParam("KEY", (Object)key);
                        AO_Users insert = (AO_Users)this.activeObjects_m.create(AO_Users.class, new DBParam[]{primaryKey});
                        insert.setPageId(pageId);
                        insert.setUserKey(userKey);
                        insert.setIsModerator(false);
                        insert.setShowHiddenContent(true);
                        insert.save();
                    }
                } else {
                    users[0].setShowHiddenContent(allow);
                    users[0].save();
                }
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public boolean showHiddenContent(String pageId, String userKey) {
        try {
            String key = pageId + userKey;
            AO_Users[] users = (AO_Users[])this.activeObjects_m.find(AO_Users.class, Query.select().where("KEY = ?", new Object[]{key}));
            if (users.length == 0) {
                return false;
            }
            return users[0].getShowHiddenContent();
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
            return false;
        }
    }

    @Override
    public void setContentStatus(String pageId, int status) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                AO_Forums[] forums = (AO_Forums[])this.activeObjects_m.find(AO_Forums.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
                if (forums.length == 0) {
                    AO_Topics[] topics = (AO_Topics[])this.activeObjects_m.find(AO_Topics.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
                    if (topics.length == 0) {
                        DBParam primaryKey = new DBParam("PAGE_ID", (Object)pageId);
                        AO_Forums insert = (AO_Forums)this.activeObjects_m.create(AO_Forums.class, new DBParam[]{primaryKey});
                        insert.setStatus(status);
                        insert.save();
                    } else {
                        topics[0].setStatus(status);
                        topics[0].save();
                    }
                } else {
                    forums[0].setStatus(status);
                    forums[0].save();
                }
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public Integer getContentStatus(String pageId) {
        Integer status = StatusType.Active;
        try {
            AO_Forums[] forums = (AO_Forums[])this.activeObjects_m.find(AO_Forums.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
            if (forums.length == 0) {
                AO_Topics[] topics = (AO_Topics[])this.activeObjects_m.find(AO_Topics.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
                if (topics.length == 0) {
                    return StatusType.Active;
                }
                status = topics[0].getStatus();
            } else {
                status = forums[0].getStatus();
            }
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
        }
        return status == null ? StatusType.Active : status;
    }

    @Override
    public void setTopicCreatorsGroup(String pageId, String groupName) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                AO_Forums[] forums = (AO_Forums[])this.activeObjects_m.find(AO_Forums.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
                if (forums.length == 0) {
                    logger_m.error("PageId {} is not a Forum", (Object)pageId);
                    return null;
                }
                forums[0].setTopicCreatorsGroup(groupName);
                forums[0].save();
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public String getTopicCreatorsGroup(String pageId) {
        try {
            AO_Forums[] forums = (AO_Forums[])this.activeObjects_m.find(AO_Forums.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
            if (forums.length == 0) {
                logger_m.error("PageId {} is not a Forum", (Object)pageId);
                return "";
            }
            return forums[0].getTopicCreatorsGroup();
        }
        catch (Exception e) {
            logger_m.error(e.getMessage());
            return "";
        }
    }

    @Override
    public void addForumData(String pageId, String topicCreatorsGroup, Integer status, Long lastUpdatedId) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                logger_m.info("Adding Forum data pageID: {} Creators Group: {} status: {} lastUpdatedID: {}", new Object[]{pageId, topicCreatorsGroup, status, lastUpdatedId});
                DBParam primaryKey = new DBParam("PAGE_ID", (Object)pageId);
                AO_Forums insert = (AO_Forums)this.activeObjects_m.create(AO_Forums.class, new DBParam[]{primaryKey});
                insert.setTopicCreatorsGroup(topicCreatorsGroup);
                insert.setLastUpdatedId(lastUpdatedId);
                insert.setStatus(status);
                insert.save();
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public void addTopicData(String pageId, Long views, Integer status, Long lastUpdatedId) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                logger_m.info("Migrating Topic data pageID: {} Views: {} status: {} lastUpdatedID: {}", new Object[]{pageId, views, status, lastUpdatedId});
                DBParam primaryKey = new DBParam("PAGE_ID", (Object)pageId);
                AO_Topics insert = (AO_Topics)this.activeObjects_m.create(AO_Topics.class, new DBParam[]{primaryKey});
                insert.setViews(views);
                insert.setStatus(status);
                insert.setLastUpdatedId(lastUpdatedId);
                insert.save();
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public void copyDataToUsers(Long max) {
        this.activeObjects_m.executeInTransaction(() -> {
            try {
                AO_Topics[] topics;
                AO_Forums[] forums;
                for (AO_Forums forum : forums = (AO_Forums[])this.activeObjects_m.find(AO_Forums.class)) {
                    Set<String> moderators = this.getSetFromString(forum.getModerators());
                    String pageId = forum.getPageId();
                    for (String moderator : moderators) {
                        logger_m.info("copying moderator {} to new Table with pageId {}", (Object)moderator, (Object)pageId);
                        this.addForumModerator(pageId, moderator);
                    }
                    Set<String> userKeys = this.getSetFromString(forum.getHiddenAccessUsers());
                    for (String userKey : userKeys) {
                        logger_m.info("copying userkey {} to new Table with pageId {}", (Object)userKey, (Object)pageId);
                        this.allowHiddenAccess(pageId, userKey, true);
                    }
                }
                for (AO_Topics topic : topics = (AO_Topics[])this.activeObjects_m.find(AO_Topics.class)) {
                    Set<String> userKeys = this.getSetFromString(topic.getHiddenAccessUsers());
                    String pageId = topic.getPageId();
                    for (String userKey : userKeys) {
                        logger_m.info("copying userkey {} to new Table with pageId {}", (Object)userKey, (Object)pageId);
                        this.allowHiddenAccess(pageId, userKey, true);
                    }
                }
            }
            catch (Exception e) {
                logger_m.error(e.getMessage());
            }
            return null;
        });
    }

    @Override
    public void exportTopics(PrintWriter csvFile) {
        CsvWriterTopics callback = new CsvWriterTopics(csvFile);
        this.activeObjects_m.stream(AO_Topics.class, callback::writeRow);
    }

    @Override
    public void exportForums(PrintWriter csvFile) {
        CsvWriterForums callback = new CsvWriterForums(csvFile);
        this.activeObjects_m.stream(AO_Forums.class, callback::writeRow);
    }

    @Override
    public void exportUsers(PrintWriter csvFile) {
        CsvWriterUsers callback = new CsvWriterUsers(csvFile);
        this.activeObjects_m.stream(AO_Users.class, callback::writeRow);
    }

    private class CsvWriterTopics {
        private final PrintWriter writer_m;

        CsvWriterTopics(PrintWriter writer) {
            this.writer_m = writer;
            this.writer_m.println("ID,PAGE_ID,VIEWS,STATUS,LAST_UPDATED_ID");
        }

        public void writeRow(AO_Topics data) {
            this.writer_m.println(String.format("%d,%s,%d,%d,%d", data.getID(), data.getPageId(), data.getViews(), data.getStatus(), data.getLastUpdatedId()));
        }
    }

    private class CsvWriterForums {
        private final PrintWriter writer_m;

        CsvWriterForums(PrintWriter writer) {
            this.writer_m = writer;
            this.writer_m.println("ID,PAGE_ID,TOPIC_CREATORS_GROUP,STATUS,LAST_UPDATED_ID");
        }

        public void writeRow(AO_Forums data) {
            this.writer_m.println(String.format("%d,%s,%s,%d,%d", data.getID(), data.getPageId(), data.getTopicCreatorsGroup(), data.getStatus(), data.getLastUpdatedId()));
        }
    }

    private class CsvWriterUsers {
        private final PrintWriter writer_m;

        CsvWriterUsers(PrintWriter writer) {
            this.writer_m = writer;
            this.writer_m.println("ID,PAGE_ID,MODERATOR_KEY,SHOW_HIDDEN_CONTENT");
        }

        public void writeRow(AO_Users data) {
            this.writer_m.println(String.format("%d,%s,%b,%b", data.getID(), data.getPageId(), data.getIsModerator(), data.getShowHiddenContent()));
        }
    }
}

