/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.createcontent.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.plugins.createcontent.events.SpaceBlueprintCreateEvent;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.Version;
import net.kentcom.common.scheduler.SchedulerManager;
import net.kentcom.easyforums.AddLabelsThread;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.ForumDataService;
import net.kentcom.easyforums.ForumUtilities;
import net.kentcom.easyforums.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class EasyForums
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher_m;
    private final TransactionTemplate transactionTemplate_m;
    private final SchedulerManager schedulerManager_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final CQLSearchService cqlSearchService_m;
    private final BandanaManager bandanaManager_m;
    private final NotificationManager notificationManager_m;
    private final AppConfigSettings appConfigSetting_m;
    private final LicenseCheck licenseCheck_m;
    private final LabelManager labelManager_m;
    private final UserAccessor userAccessor_m;
    private final StatusType statusType_m;
    private final ForumUtilities forumUtilities_m;
    private final ForumDataService forumDataService_m;
    private final PageManager pageManager_m;
    private final Logger logger_m = LoggerFactory.getLogger(EasyForums.class);
    private List<Long> homePagesToLabel_m = new ArrayList<Long>();

    @Inject
    public EasyForums(@ComponentImport EventPublisher eventPublisher, @ComponentImport BandanaManager bandanaManager, @ComponentImport UserAccessor userAccessor, @ComponentImport NotificationManager notificationManager, @ComponentImport PageManager pageManager, @ComponentImport LabelManager labelManager, @ComponentImport CQLSearchService cqlSearchService, @ComponentImport TransactionTemplate transactionTemplate, LicenseCheck licenseCheck, ConfluenceUtilities confluenceUtilities, ForumUtilities forumUtilities, SchedulerManager schedulerManager, StatusType statusType, ForumDataService forumDataService, AppConfigSettings appConfigSetting) {
        this.eventPublisher_m = eventPublisher;
        this.bandanaManager_m = bandanaManager;
        this.notificationManager_m = notificationManager;
        this.labelManager_m = labelManager;
        this.transactionTemplate_m = transactionTemplate;
        this.userAccessor_m = userAccessor;
        this.licenseCheck_m = licenseCheck;
        this.appConfigSetting_m = appConfigSetting;
        this.confluenceUtilities_m = confluenceUtilities;
        this.schedulerManager_m = schedulerManager;
        this.cqlSearchService_m = cqlSearchService;
        this.statusType_m = statusType;
        this.forumUtilities_m = forumUtilities;
        this.forumDataService_m = forumDataService;
        this.pageManager_m = pageManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.logger_m.info("afterPropertiesSet");
        ConfluenceUtilities.enableLogging();
        this.eventPublisher_m.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher_m.unregister((Object)this);
        this.schedulerManager_m.destroy();
    }

    @PluginEventListener
    public void pluginEnabledEvent(PluginEnabledEvent event) {
        if (event.getPlugin().getKey().equals("net.kentcom.easy-forums")) {
            this.logger_m.info("_____ Detected our pluginEnabledEvent _____");
            if (this.userAccessor_m.getGroup(ForumConstants.moderatorGroupName_m) == null) {
                try {
                    ConfluenceUser admin = this.confluenceUtilities_m.getAdminUser();
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
                    this.userAccessor_m.createGroup(ForumConstants.moderatorGroupName_m);
                    AuthenticatedUserThreadLocal.reset();
                }
                catch (Exception e) {
                    this.logger_m.error(e.getMessage());
                    this.logger_m.error("Unable to create Confluence Group \"{}\" please create this Confluence Group Manually", (Object)ForumConstants.moderatorGroupName_m);
                }
            }
            this.appConfigSetting_m.initialise(ForumConstants.settingsContextStr_m);
            this.appConfigSetting_m.addString(ForumConstants.pluginVersion_m, this.licenseCheck_m.getPluginVersion());
            this.appConfigSetting_m.addBoolean(ForumConstants.showAvatar_m, Boolean.TRUE);
            this.appConfigSetting_m.addBoolean(ForumConstants.renderTablesOnly_m, Boolean.FALSE);
            this.appConfigSetting_m.addString(ForumConstants.forumTemplate_m, "EasyForums-Forum");
            this.appConfigSetting_m.addLong(ForumConstants.maxTableItems_m, 100L);
            this.appConfigSetting_m.addString(ForumConstants.defaultSortColumn_m, ForumConstants.SummaryColumns.LAST_POST.name());
            this.appConfigSetting_m.addBoolean(ForumConstants.showLabels_m, Boolean.FALSE);
            this.appConfigSetting_m.addBoolean(ForumConstants.showSidebar_m, Boolean.FALSE);
            this.appConfigSetting_m.addLong(ForumConstants.maxForumModerators_m, 3L);
            this.appConfigSetting_m.addString(ForumConstants.upgradeStatus_m, ForumConstants.UpgradeStatus.NOT_REQUIRED.name());
            this.forumUtilities_m.getSummaryMap();
            this.forumUtilities_m.getForumMap();
            Label label = this.labelManager_m.getLabel(ForumConstants.forumLabelStr_m);
            ForumConstants.forumLabel_m = label == null ? this.labelManager_m.createLabel(new Label(ForumConstants.forumLabelStr_m)) : label;
            label = this.labelManager_m.getLabel(ForumConstants.topicLabelStr_m);
            ForumConstants.topicLabel_m = label == null ? this.labelManager_m.createLabel(new Label(ForumConstants.topicLabelStr_m)) : label;
            label = this.labelManager_m.getLabel(ForumConstants.homeLabelStr_m);
            ForumConstants.homeLabel_m = label == null ? this.labelManager_m.createLabel(new Label(ForumConstants.homeLabelStr_m)) : label;
            this.statusType_m.initialise();
            this.checkVersion();
        }
    }

    private void checkVersion() {
        Version currentVer = Version.getInstance(this.licenseCheck_m.getPluginVersion());
        this.logger_m.info("Current Version: {}", (Object)currentVer);
        Version previousVer = Version.getInstance(this.appConfigSetting_m.getString(ForumConstants.pluginVersion_m));
        this.logger_m.info("Previous Version: {}", (Object)previousVer);
        if (currentVer.equals(previousVer)) {
            return;
        }
        Version addAO = Version.getInstance("4.6");
        Version addUserTable = Version.getInstance("4.8");
        Version addPageIdLabels = Version.getInstance("4.9");
        if (previousVer != null) {
            if (previousVer.before(addAO)) {
                this.appConfigSetting_m.setString(ForumConstants.upgradeStatus_m, ForumConstants.UpgradeStatus.IN_PROGRESS.name());
                if (this.migrateBandanaToAO()) {
                    this.appConfigSetting_m.setString(ForumConstants.upgradeStatus_m, ForumConstants.UpgradeStatus.COMPLETE.name());
                } else {
                    this.appConfigSetting_m.setString(ForumConstants.upgradeStatus_m, ForumConstants.UpgradeStatus.FAILED.name());
                }
            } else if (previousVer.before(addUserTable)) {
                this.copyDataToUsers();
            } else if (previousVer.before(addPageIdLabels)) {
                AddLabelsThread task = new AddLabelsThread(this.transactionTemplate_m, this.confluenceUtilities_m, this.pageManager_m, this.labelManager_m, this.cqlSearchService_m);
                ExecutorService executorService = Executors.newFixedThreadPool(1);
                executorService.execute(task);
            }
        }
        this.appConfigSetting_m.setString(ForumConstants.pluginVersion_m, currentVer.toString());
    }

    @EventListener
    public void onPageViewEvent(PageViewEvent event) {
        if (!this.confluenceUtilities_m.isConfluenceReadOnly()) {
            Page page = event.getPage();
            if (ForumConstants.isPageTopic((Labelable)page)) {
                this.forumDataService_m.incrementTopicViewCount(page.getIdAsString());
            }
            if (this.homePagesToLabel_m.contains(page.getId())) {
                this.labelManager_m.addLabel((Labelable)page, ForumConstants.homeLabel_m);
                this.homePagesToLabel_m.remove(page.getId());
            }
        }
    }

    private void labelWithAncestors(Labelable content, ContentEntityObject owner) {
        Page topic = (Page)owner;
        Page forum = topic.getParent();
        this.labelManager_m.addLabel(content, new Label(forum.getIdAsString()));
        Page home = forum.getParent();
        if (ForumConstants.isPageHome((Labelable)home)) {
            this.labelManager_m.addLabel(content, new Label(home.getIdAsString()));
        }
    }

    @EventListener
    public void commentCreateEvent(CommentCreateEvent event) {
        Comment comment = event.getComment();
        ContentEntityObject page = comment.getContainer();
        if (ForumConstants.isPageTopic((Labelable)page)) {
            this.storeLastUpdateTime(page, (ContentEntityObject)comment);
            this.labelWithAncestors((Labelable)comment, page);
        }
    }

    @EventListener
    public void commentUpdateEvent(CommentUpdateEvent event) {
        Comment comment = event.getComment();
        ContentEntityObject page = comment.getContainer();
        if (ForumConstants.isPageTopic((Labelable)page)) {
            this.storeLastUpdateTime(page, (ContentEntityObject)comment);
        }
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        Page page = event.getPage();
        if (ForumConstants.isPageTopic((Labelable)page)) {
            this.storeLastUpdateTime((ContentEntityObject)page, (ContentEntityObject)page);
        }
    }

    @EventListener
    public void onBlueprintCreateEvent(BlueprintPageCreateEvent event) {
        String topicModuleKey = "net.kentcom.easy-forums:ef-create-topic-template";
        String forumModuleKey = "net.kentcom.easy-forums:ef-create-forum-template";
        Page page = event.getPage();
        String templateCompleteKey = (String)event.getContext().get("itemModuleCompleteKey");
        if (templateCompleteKey != null) {
            if (templateCompleteKey.equals(topicModuleKey)) {
                this.storeLastUpdateTime((ContentEntityObject)page, (ContentEntityObject)page);
                for (Notification notification : this.notificationManager_m.getNotificationsByContent((ContentEntityObject)page.getParent())) {
                    this.notificationManager_m.addContentNotification((User)notification.getReceiver(), (ContentEntityObject)page);
                }
                this.labelWithAncestors((Labelable)page, (ContentEntityObject)page);
            } else if (templateCompleteKey.equals(forumModuleKey)) {
                this.forumDataService_m.addForumData(page.getIdAsString(), null, StatusType.Active, null);
            }
        }
    }

    @EventListener
    public void onSpaceBlueprintCreateEvent(SpaceBlueprintCreateEvent event) {
        String efSpaceModuleKey = "net.kentcom.easy-forums:ef-space-home";
        String moduleCompleteKey = event.getSpaceBlueprint().getModuleCompleteKey();
        if (efSpaceModuleKey.equals(moduleCompleteKey)) {
            Page home = event.getSpace().getHomePage();
            this.homePagesToLabel_m.add(home.getId() + 1L);
        }
    }

    private void storeLastUpdateTime(ContentEntityObject topic, ContentEntityObject update) {
        this.forumDataService_m.setLastUpdateId(topic.getIdAsString(), update.getId(), true);
        this.forumDataService_m.setLastUpdateId(((Page)topic).getParent().getIdAsString(), update.getId(), false);
    }

    private void copyDataToUsers() {
        try {
            this.transactionTemplate_m.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    Long max = EasyForums.this.appConfigSetting_m.getLong(ForumConstants.maxForumModerators_m);
                    EasyForums.this.forumDataService_m.copyDataToUsers(max);
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
        }
    }

    public boolean migrateBandanaToAO() {
        this.logger_m.info("Migrating data");
        ConfluenceUser admin = this.confluenceUtilities_m.getAdminUser();
        AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
        try {
            this.transactionTemplate_m.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    String pageId;
                    PageResponse searchResults;
                    EasyForums.this.forumDataService_m.deleteAllData();
                    List userKeys = (List)EasyForums.this.bandanaManager_m.getKeys((BandanaContext)ForumConstants.showHiddenContext_m);
                    ArrayList<String> moderatorsWithHidden = new ArrayList<String>();
                    for (String userKey : userKeys) {
                        String value = (String)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.showHiddenContext_m, userKey);
                        if (!value.equalsIgnoreCase("true")) continue;
                        moderatorsWithHidden.add(userKey);
                    }
                    int limit = 100;
                    int start = 0;
                    boolean finished = false;
                    Long max = EasyForums.this.appConfigSetting_m.getLong(ForumConstants.maxForumModerators_m);
                    while (!finished) {
                        searchResults = EasyForums.this.cqlSearchService_m.searchContent("label = \"easyforums-forum\"", (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                        for (Content content : searchResults.getResults()) {
                            EasyForums.this.logger_m.info("Migrating Forum Page {} with ID {}", (Object)content.getTitle(), (Object)content.getId().toString());
                            pageId = content.getId().serialise();
                            String topicCreatorsGroup = (String)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.topicCreatorsContext_m, pageId);
                            ConfluenceBandanaContext modContext = new ConfluenceBandanaContext(ForumConstants.moderatorContentPrefix_m + pageId);
                            List moderators = (List)EasyForums.this.bandanaManager_m.getKeys((BandanaContext)modContext);
                            for (String moderator : moderators) {
                                EasyForums.this.forumDataService_m.addForumModerator(pageId, moderator);
                            }
                            Integer status = (Integer)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.statusContext_m, pageId);
                            if (status == null) {
                                status = StatusType.Active;
                            }
                            Long lastUpdatedId = (Long)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.bandanaContext_m, pageId);
                            EasyForums.this.forumDataService_m.addForumData(pageId, topicCreatorsGroup, status, lastUpdatedId);
                            for (String userKey : moderatorsWithHidden) {
                                EasyForums.this.forumDataService_m.allowHiddenAccess(pageId, userKey, true);
                            }
                        }
                        if (searchResults.hasMore()) {
                            start += limit;
                            continue;
                        }
                        finished = true;
                    }
                    finished = false;
                    while (!finished) {
                        searchResults = EasyForums.this.cqlSearchService_m.searchContent("label = \"easyforums-topic\"", (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                        for (Content content : searchResults.getResults()) {
                            EasyForums.this.logger_m.info("Migrating Topic Page {} with ID {}", (Object)content.getTitle(), (Object)content.getId().toString());
                            pageId = content.getId().serialise();
                            Integer status = (Integer)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.statusContext_m, pageId);
                            if (status == null) {
                                status = StatusType.Active;
                            }
                            Long numViews = (Long)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.pageViewContext_m, pageId);
                            Long lastUpdatedId = (Long)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.bandanaContext_m, pageId);
                            EasyForums.this.forumDataService_m.addTopicData(pageId, numViews, status, lastUpdatedId);
                            for (String userKey : moderatorsWithHidden) {
                                EasyForums.this.forumDataService_m.allowHiddenAccess(pageId, userKey, true);
                            }
                        }
                        if (searchResults.hasMore()) {
                            start += limit;
                            continue;
                        }
                        finished = true;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
            AuthenticatedUserThreadLocal.reset();
            return false;
        }
        AuthenticatedUserThreadLocal.reset();
        return true;
    }

    public void deleteBandanaData() {
        this.logger_m.info("Deleting data");
        ConfluenceUser admin = this.confluenceUtilities_m.getAdminUser();
        AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
        try {
            this.transactionTemplate_m.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    String pageId;
                    PageResponse searchResults;
                    List userKeys = (List)EasyForums.this.bandanaManager_m.getKeys((BandanaContext)ForumConstants.showHiddenContext_m);
                    for (String key : userKeys) {
                        EasyForums.this.bandanaManager_m.removeValue((BandanaContext)ForumConstants.showHiddenContext_m, key);
                    }
                    int limit = 100;
                    int start = 0;
                    boolean finished = false;
                    while (!finished) {
                        searchResults = EasyForums.this.cqlSearchService_m.searchContent("label = \"easyforums-forum\"", (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                        for (Content content : searchResults.getResults()) {
                            pageId = content.getId().serialise();
                            EasyForums.this.bandanaManager_m.removeValue((BandanaContext)ForumConstants.topicCreatorsContext_m, pageId);
                            ConfluenceBandanaContext modContext = new ConfluenceBandanaContext(ForumConstants.moderatorContentPrefix_m + pageId);
                            List moderators = (List)EasyForums.this.bandanaManager_m.getKeys((BandanaContext)modContext);
                            for (String key : moderators) {
                                EasyForums.this.bandanaManager_m.removeValue((BandanaContext)modContext, key);
                            }
                            EasyForums.this.bandanaManager_m.removeValue((BandanaContext)ForumConstants.statusContext_m, pageId);
                            EasyForums.this.bandanaManager_m.removeValue((BandanaContext)ForumConstants.bandanaContext_m, pageId);
                        }
                        if (searchResults.hasMore()) {
                            start += limit;
                            continue;
                        }
                        finished = true;
                    }
                    finished = false;
                    while (!finished) {
                        searchResults = EasyForums.this.cqlSearchService_m.searchContent("label = \"easyforums-topic\"", (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                        for (Content content : searchResults.getResults()) {
                            pageId = content.getId().serialise();
                            EasyForums.this.bandanaManager_m.removeValue((BandanaContext)ForumConstants.statusContext_m, pageId);
                            EasyForums.this.bandanaManager_m.removeValue((BandanaContext)ForumConstants.pageViewContext_m, pageId);
                            EasyForums.this.bandanaManager_m.removeValue((BandanaContext)ForumConstants.bandanaContext_m, pageId);
                        }
                        if (searchResults.hasMore()) {
                            start += limit;
                            continue;
                        }
                        finished = true;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
        }
        AuthenticatedUserThreadLocal.reset();
        this.appConfigSetting_m.setString(ForumConstants.upgradeStatus_m, ForumConstants.UpgradeStatus.NOT_POSSIBLE.name());
    }

    public void exportBandanaData(PrintWriter csvFile) {
        this.logger_m.info("Exporting data");
        ConfluenceUser admin = this.confluenceUtilities_m.getAdminUser();
        AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
        final CsvWriterBandana writer = new CsvWriterBandana(csvFile);
        try {
            this.transactionTemplate_m.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    String pageId;
                    PageResponse searchResults;
                    List userKeys = (List)EasyForums.this.bandanaManager_m.getKeys((BandanaContext)ForumConstants.showHiddenContext_m);
                    for (String key : userKeys) {
                        String value = (String)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.showHiddenContext_m, key);
                        writer.writeRow(ForumConstants.showHiddenContext_m.getSpaceKey(), key, value, "Hidden Mod/Admin status for all Forms/Topics");
                    }
                    int limit = 100;
                    int start = 0;
                    boolean finished = false;
                    while (!finished) {
                        searchResults = EasyForums.this.cqlSearchService_m.searchContent("label = \"easyforums-forum\"", (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                        for (Content content : searchResults.getResults()) {
                            pageId = content.getId().serialise();
                            String topicCreatorsGroup = (String)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.topicCreatorsContext_m, pageId);
                            writer.writeRow(ForumConstants.topicCreatorsContext_m.getContextKey(), pageId, topicCreatorsGroup, "TopicCreatorsGroup name for this Forum");
                            ConfluenceBandanaContext modContext = new ConfluenceBandanaContext(ForumConstants.moderatorContentPrefix_m + pageId);
                            List moderators = (List)EasyForums.this.bandanaManager_m.getKeys((BandanaContext)modContext);
                            for (String key : moderators) {
                                String value = (String)EasyForums.this.bandanaManager_m.getValue((BandanaContext)modContext, key);
                                writer.writeRow(modContext.getContextKey(), key, value, "Moderator for this Forum");
                            }
                            Integer status = (Integer)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.statusContext_m, pageId);
                            writer.writeRow(ForumConstants.statusContext_m.getContextKey(), pageId, String.valueOf(status), "Status of the forum - null=Active");
                            Long lastUpdatedId = (Long)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.bandanaContext_m, pageId);
                            writer.writeRow(ForumConstants.bandanaContext_m.getContextKey(), pageId, String.valueOf(lastUpdatedId), "ID of last updated content in Forum");
                        }
                        if (searchResults.hasMore()) {
                            start += limit;
                            continue;
                        }
                        finished = true;
                    }
                    finished = false;
                    while (!finished) {
                        searchResults = EasyForums.this.cqlSearchService_m.searchContent("label = \"easyforums-topic\"", (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                        for (Content content : searchResults.getResults()) {
                            pageId = content.getId().serialise();
                            Integer status = (Integer)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.statusContext_m, pageId);
                            writer.writeRow(ForumConstants.statusContext_m.getContextKey(), pageId, String.valueOf(status), "Status of the Topic - null=Active");
                            Long numViews = (Long)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.pageViewContext_m, pageId);
                            writer.writeRow(ForumConstants.pageViewContext_m.getContextKey(), pageId, String.valueOf(numViews), "ViewCount of Topic");
                            Long lastUpdatedId = (Long)EasyForums.this.bandanaManager_m.getValue((BandanaContext)ForumConstants.bandanaContext_m, pageId);
                            writer.writeRow(ForumConstants.bandanaContext_m.getContextKey(), pageId, String.valueOf(lastUpdatedId), "ID of last updated Comment in Topic");
                        }
                        if (searchResults.hasMore()) {
                            start += limit;
                            continue;
                        }
                        finished = true;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
        }
        AuthenticatedUserThreadLocal.reset();
    }

    private class CsvWriterBandana {
        private final PrintWriter writer_m;

        CsvWriterBandana(PrintWriter writer) {
            this.writer_m = writer;
            this.writer_m.println("CONTEXT,KEY,VALUE,COMMENT");
        }

        public void writeRow(String context, String key, String value, String comment) {
            this.writer_m.println(String.format("%s,%s,%s,%s", context, key, value, comment));
        }
    }
}

