/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.ForumConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLabelsThread
implements Runnable {
    private final CQLSearchService cqlSearchService_m;
    private final PageManager pageManager_m;
    private final LabelManager labelManager_m;
    private final TransactionTemplate transactionTemplate_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());

    public AddLabelsThread(TransactionTemplate transactionTemplate, ConfluenceUtilities confluenceUtilities, PageManager pageManager, LabelManager labelManager, CQLSearchService cqlSearchService) {
        this.pageManager_m = pageManager;
        this.labelManager_m = labelManager;
        this.cqlSearchService_m = cqlSearchService;
        this.transactionTemplate_m = transactionTemplate;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    @Override
    public void run() {
        ConfluenceUser adminUser = this.confluenceUtilities_m.getAdminUser();
        AuthenticatedUserThreadLocal.set((ConfluenceUser)adminUser);
        this.logger_m.info("Running as User: {}", (Object)adminUser.getName());
        this.transactionTemplate_m.execute(new TransactionCallback(){

            public Object doInTransaction() {
                AddLabelsThread.this.labelHomePages();
                AddLabelsThread.this.labelTopicPagesAndComments();
                return null;
            }
        });
        this.logger_m.info("Process Complete");
    }

    private void labelHomePages() {
        try {
            int limit = 100;
            int start = 0;
            boolean finished = false;
            while (!finished) {
                PageResponse searchResults = this.cqlSearchService_m.searchContent("macro = forum", (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                for (Content content : searchResults.getResults()) {
                    Page home = (Page)this.pageManager_m.getById(content.getId().asLong());
                    if (home == null) continue;
                    this.labelManager_m.addLabel((Labelable)home, ForumConstants.homeLabel_m);
                    this.logger_m.info("Labelled home page: " + home.getTitle());
                }
                if (searchResults.hasMore()) {
                    start += limit;
                    continue;
                }
                finished = true;
            }
        }
        catch (Exception e) {
            this.logger_m.error("Error labelling content: {}", (Object)e.getMessage());
        }
    }

    private void labelTopicPagesAndComments() {
        try {
            int limit = 100;
            int start = 0;
            boolean finished = false;
            while (!finished) {
                PageResponse searchResults = this.cqlSearchService_m.searchContent("macro = \"most-popular-comment\"", (PageRequest)new SimplePageRequest(start, limit), new Expansion[0]);
                for (Content content : searchResults.getResults()) {
                    Page topic = (Page)this.pageManager_m.getById(content.getId().asLong());
                    Page forum = topic.getParent();
                    if (forum == null) continue;
                    String forumId = forum.getIdAsString();
                    String homeId = null;
                    Page home = forum.getParent();
                    if (home != null && ForumConstants.isPageHome((Labelable)home)) {
                        homeId = home.getIdAsString();
                    }
                    this.labelManager_m.addLabel((Labelable)topic, new Label(forumId));
                    if (homeId != null) {
                        this.labelManager_m.addLabel((Labelable)topic, new Label(homeId));
                    }
                    this.logger_m.info("Labelled topic page: " + topic.getTitle());
                    for (Label label : topic.getLabels()) {
                        this.logger_m.info(label.getName());
                    }
                    this.labelAllComments((ContentEntityObject)topic, forumId, homeId);
                }
                if (searchResults.hasMore()) {
                    start += limit;
                    continue;
                }
                finished = true;
            }
        }
        catch (Exception e) {
            this.logger_m.error("Error labelling content: " + e.getMessage());
        }
    }

    private void labelAllComments(ContentEntityObject owner, String forumId, String homeId) {
        for (Comment comment : owner.getComments()) {
            this.labelManager_m.addLabel((Labelable)comment, new Label(forumId));
            if (homeId != null) {
                this.labelManager_m.addLabel((Labelable)comment, new Label(homeId));
            }
            this.logger_m.info("Labelled comment: " + comment.getBodyAsString());
            for (Label label : comment.getLabels()) {
                this.logger_m.info(label.getName());
            }
            this.labelAllComments((ContentEntityObject)comment, forumId, homeId);
        }
    }
}

