/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common.cron.rule.field;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import net.kentcom.common.cron.rule.field.DayOfWeekConstantConverter;
import net.kentcom.common.cron.rule.field.SpecialDayFieldRule;

public class SpecialDayOfWeekLastFieldRule
extends SpecialDayFieldRule {
    private static final long serialVersionUID = 4480059862309727633L;
    private final int isoDayOfWeek;

    public SpecialDayOfWeekLastFieldRule(int cronDayOfWeek) {
        if (cronDayOfWeek < 1 || cronDayOfWeek > 7) {
            throw new IllegalArgumentException("cronDayOfWeek must be in the range [1,7]");
        }
        this.isoDayOfWeek = DayOfWeekConstantConverter.cronToIso(cronDayOfWeek);
    }

    @Override
    int calculateMatchingDay(int year, int month) {
        LocalDate firstDay = LocalDate.of(year, month, 1);
        LocalDate lastDayOfMonth = firstDay.withDayOfMonth(firstDay.lengthOfMonth());
        DayOfWeek targetDayOfWeek = DayOfWeek.of(this.isoDayOfWeek);
        LocalDate date = lastDayOfMonth.getDayOfWeek().getValue() < this.isoDayOfWeek ? lastDayOfMonth.with(TemporalAdjusters.nextOrSame(targetDayOfWeek)) : lastDayOfMonth.with(TemporalAdjusters.previousOrSame(targetDayOfWeek));
        if (date.isAfter(lastDayOfMonth)) {
            date = date.minusWeeks(1L);
        }
        return date.getDayOfMonth();
    }

    @Override
    protected void appendTo(StringBuilder sb) {
        sb.append(DayOfWeekConstantConverter.isoToCron(this.isoDayOfWeek)).append('L');
    }
}

