/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common.cron.rule.field;

import net.kentcom.common.cron.rule.DateTimeTemplate;
import net.kentcom.common.cron.rule.field.AbstractFieldRule;
import net.kentcom.common.cron.rule.field.FieldRule;
import net.kentcom.common.cron.rule.field.SingleValueFieldRule;

public class RangeFieldRule
extends AbstractFieldRule {
    private static final long serialVersionUID = -8064232881796546833L;
    private final int min;
    private final int max;

    private RangeFieldRule(DateTimeTemplate.Field field, int min, int max) {
        super(field);
        this.min = min;
        this.max = max;
    }

    public static FieldRule of(DateTimeTemplate.Field field, int min, int max) {
        if (min < 0) {
            throw new IllegalArgumentException("min must be non negative");
        }
        if (min == max) {
            return new SingleValueFieldRule(field, min);
        }
        if (min >= max) {
            throw new IllegalArgumentException("min must be less than max");
        }
        return new RangeFieldRule(field, min, max);
    }

    @Override
    public boolean matches(DateTimeTemplate dateTime) {
        int value = this.get(dateTime);
        return value >= this.min && value <= this.max;
    }

    @Override
    public boolean first(DateTimeTemplate dateTime) {
        this.set(dateTime, this.min);
        return true;
    }

    @Override
    public boolean next(DateTimeTemplate dateTime) {
        int value = this.get(dateTime);
        if (value >= this.max) {
            return false;
        }
        int nextValue = value < this.min ? this.min : value + 1;
        this.set(dateTime, nextValue);
        return true;
    }

    @Override
    protected void appendTo(StringBuilder sb) {
        if (this.min == this.field.getMinimumValue() && this.max == this.field.getMaximumValue()) {
            sb.append('*');
        } else {
            sb.append(this.min).append('-').append(this.max);
        }
    }
}

