/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common.cron.rule.field;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.BitSet;
import java.util.Objects;
import net.kentcom.common.cron.rule.DateTimeTemplate;
import net.kentcom.common.cron.rule.field.AbstractFieldRule;
import net.kentcom.common.cron.rule.field.DayOfWeekConstantConverter;
import net.kentcom.common.cron.rule.field.FieldRule;

public class DayOfWeekFieldRule
extends AbstractFieldRule {
    private static final long serialVersionUID = -5922219253093923249L;
    private static final DayOfWeekFieldRule SATURDAY = new DayOfWeekFieldRule();
    private final BitSet isoDaysOfWeek;

    public static DayOfWeekFieldRule saturday() {
        return SATURDAY;
    }

    private DayOfWeekFieldRule() {
        super(DateTimeTemplate.Field.DAY);
        BitSet saturday = new BitSet(8);
        saturday.set(DayOfWeek.SATURDAY.getValue());
        this.isoDaysOfWeek = saturday;
    }

    private DayOfWeekFieldRule(BitSet values) {
        super(DateTimeTemplate.Field.DAY);
        Objects.requireNonNull(values, "values");
        if (values.isEmpty()) {
            throw new IllegalArgumentException("values cannot be empty");
        }
        if (values.get(0)) {
            throw new IllegalArgumentException("values cannot contain 0");
        }
        if (values.nextSetBit(8) != -1) {
            throw new IllegalArgumentException("values cannot contain anything > 7");
        }
        this.isoDaysOfWeek = DayOfWeekConstantConverter.cronToIso(values);
    }

    public static FieldRule of(BitSet values) {
        return new DayOfWeekFieldRule(values);
    }

    @Override
    public boolean matches(DateTimeTemplate dateTime) {
        LocalDate firstOfMonth = dateTime.toFirstDayOfMonth();
        int lastDayOfMonth = firstOfMonth.lengthOfMonth();
        if (dateTime.getDay() > lastDayOfMonth) {
            return false;
        }
        int isoDayOfWeek = DayOfWeekFieldRule.getIsoDayOfWeek(firstOfMonth, dateTime.getDay());
        return this.isoDaysOfWeek.get(isoDayOfWeek);
    }

    @Override
    public boolean first(DateTimeTemplate dateTime) {
        int isoDayOfWeek = dateTime.toFirstDayOfMonth().getDayOfWeek().getValue();
        if (this.isoDaysOfWeek.get(isoDayOfWeek)) {
            dateTime.setDay(1);
        } else {
            dateTime.setDay(1 + this.interval(isoDayOfWeek));
        }
        return true;
    }

    @Override
    public boolean next(DateTimeTemplate dateTime) {
        int lastDayOfMonth;
        LocalDate firstOfMonth = dateTime.toFirstDayOfMonth();
        int isoDayOfWeek = DayOfWeekFieldRule.getIsoDayOfWeek(firstOfMonth, dateTime.getDay());
        int day = dateTime.getDay() + this.interval(isoDayOfWeek);
        if (day > (lastDayOfMonth = firstOfMonth.lengthOfMonth())) {
            return false;
        }
        dateTime.setDay(day);
        return true;
    }

    private int interval(int isoDayOfWeek) {
        int next = this.isoDaysOfWeek.nextSetBit(isoDayOfWeek + 1);
        if (next != -1) {
            return next - isoDayOfWeek;
        }
        next = this.isoDaysOfWeek.nextSetBit(1);
        return next - isoDayOfWeek + 7;
    }

    @Override
    protected void appendTo(StringBuilder sb) {
        int bit = this.isoDaysOfWeek.nextSetBit(1);
        if (bit == 1 && this.isoDaysOfWeek.nextClearBit(2) == 8) {
            sb.append("*(dow)");
            return;
        }
        while (bit != -1) {
            sb.append(DayOfWeekConstantConverter.isoToName(bit)).append(',');
            bit = this.isoDaysOfWeek.nextSetBit(bit + 1);
        }
        sb.setLength(sb.length() - 1);
    }

    protected Object writeReplace() {
        return this == SATURDAY ? SaturdaySentinel.INSTANCE : this;
    }

    private static int getIsoDayOfWeek(LocalDate firstOfMonth, int dayOfMonth) {
        int dayOfWeek = (firstOfMonth.getDayOfWeek().getValue() + dayOfMonth - 1) % 7;
        return dayOfWeek != 0 ? dayOfWeek : 7;
    }

    static final class SaturdaySentinel
    implements Serializable {
        private static final long serialVersionUID = 1925593671579829200L;
        static final SaturdaySentinel INSTANCE = new SaturdaySentinel();

        SaturdaySentinel() {
        }

        protected Object readResolve() {
            return DayOfWeekFieldRule.saturday();
        }
    }
}

