/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebConfigSection
extends BaseConfluenceCondition {
    private final DynamicWebInterfaceManager webInterfaceManager_m;
    private final PluginAccessor pluginAccessor_m;
    private String sectionKey_m;
    private String sectionLocation_m;
    private String pluginKey_m;
    protected final Logger logger_m = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    @Inject
    public WebConfigSection(@ComponentImport DynamicWebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.webInterfaceManager_m = webInterfaceManager;
        this.pluginAccessor_m = pluginAccessor;
    }

    public void init(Map<String, String> params) {
        this.sectionKey_m = params.get("section.key");
        this.sectionLocation_m = params.get("section.location");
        this.pluginKey_m = params.get("plugin.key");
    }

    public boolean shouldDisplay(WebInterfaceContext context) {
        return this.addWebSection();
    }

    private boolean addWebSection() {
        boolean result = true;
        try {
            Date thisPluginLoadDate = null;
            Plugin thisPlugin = this.pluginAccessor_m.getEnabledPlugin(this.pluginKey_m);
            if (thisPlugin != null && thisPlugin.getModuleDescriptor(this.sectionKey_m) != null) {
                thisPluginLoadDate = thisPlugin.getDateLoaded();
            }
            for (ModuleDescriptor descriptor : this.webInterfaceManager_m.getSections(this.sectionLocation_m)) {
                Date otherPluginLoadDate;
                if (descriptor.getPluginKey().equalsIgnoreCase(this.pluginKey_m) || !descriptor.getKey().equalsIgnoreCase(this.sectionKey_m) || !(otherPluginLoadDate = descriptor.getPlugin().getDateLoaded()).before(thisPluginLoadDate)) continue;
                result = false;
                break;
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }
}

