/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version
implements Serializable {
    public int major;
    public int minor = 0;
    public int dot = 0;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());

    private Version(String version) {
        String[] data = version.split("\\.");
        this.major = Integer.parseInt(data[0]);
        if (data.length > 1) {
            this.minor = Integer.parseInt(data[1]);
        }
        if (data.length > 2) {
            this.dot = Integer.parseInt(data[2]);
        }
    }

    public static Version getInstance(String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        return new Version(version);
    }

    public boolean equals(Version version) {
        if (version != null) {
            return this.major == version.major && this.minor == version.minor && this.dot == version.dot;
        }
        return false;
    }

    public boolean before(String version) {
        return this.before(new Version(version));
    }

    public boolean before(Version version) {
        return this.major < version.major || this.major == version.major && this.minor < version.minor || this.major == version.major && this.minor == version.minor && this.dot < version.dot;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.dot);
    }
}

