/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;

public class MapUtil {
    private static String delimiter_m = "\u00b1";

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean ascending) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        if (ascending) {
            list.sort((o1, o2) -> ((Comparable)o1.getValue()).compareTo(o2.getValue()));
        } else {
            list.sort((o1, o2) -> ((Comparable)o2.getValue()).compareTo(o1.getValue()));
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    public static <K, V> K getKeyByValue(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <K, V> String mapToString(Map<K, V> map) {
        return map.entrySet().stream().map(entry -> entry.getKey().toString() + "=" + entry.getValue().toString()).collect(Collectors.joining(delimiter_m));
    }

    public static Map<String, String> stringToSSMap(@NonNull String mapString) {
        return Arrays.stream(mapString.split(delimiter_m)).map(s -> s.split("=")).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1]));
    }

    public static Map<Long, String> stringToLSMap(@NonNull String mapString) {
        return Arrays.stream(mapString.split(delimiter_m)).map(s -> s.split("=")).collect(Collectors.toMap(parts -> Long.valueOf(parts[0]), parts -> parts[1]));
    }

    public static Map<Integer, String> stringToISMap(@NonNull String mapString) {
        return Arrays.stream(mapString.split(delimiter_m)).map(s -> s.split("=")).collect(Collectors.toMap(parts -> Integer.valueOf(parts[0]), parts -> parts[1]));
    }
}

