/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionReplacer;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.kentcom.common.ContentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

public class MacroRenameProcess
implements Runnable {
    private final String oldMacroName_m;
    private final String newMacroName_m;
    private final String paramExist_m;
    private final List<Pair<String, String>> addParams_m;
    private final List<Triplet<String, String, String>> replaceValues_m;
    private final XhtmlContent xhtmlContent_m;
    private final ConversionContext conversionContext_m;
    private final String appName_m;
    private final ConfluenceUser user_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)this.getClass().getName());

    public MacroRenameProcess(String oldMacroName, String newMacroName, String paramExist, List<Pair<String, String>> addParams, List<Triplet<String, String, String>> replaceValues, ConfluenceUser user, String appName) {
        this.xhtmlContent_m = (XhtmlContent)ContainerManager.getComponent((String)"xhtmlContent");
        this.conversionContext_m = new DefaultConversionContext(new RenderContext());
        this.oldMacroName_m = oldMacroName;
        this.newMacroName_m = newMacroName;
        this.paramExist_m = paramExist;
        this.addParams_m = addParams;
        this.replaceValues_m = replaceValues;
        this.user_m = user;
        this.appName_m = appName;
    }

    @Override
    public void run() {
        AuthenticatedUserThreadLocal.set((ConfluenceUser)this.user_m);
        this.logger_m.info("Renaming {} macro to {}", (Object)this.oldMacroName_m, (Object)this.newMacroName_m);
        this.logger_m.info("Running as User: {}", (Object)this.user_m.getName());
        try {
            SearchPageResponse<Content> searchResults = ContentManager.startSearch("macro = '" + this.oldMacroName_m + "'");
            while (searchResults != null && searchResults.size() > 0) {
                for (Content content : searchResults.getResults()) {
                    String pageName = content.getTitle();
                    this.logger_m.info("Renaming macros on page: {} of type {}", (Object)pageName, (Object)content.getType());
                    String newBody = this.replaceMacroName(((ContentBody)content.getBody().get(ContentRepresentation.STORAGE)).getValue());
                    if (newBody == null) continue;
                    String versionComment = this.oldMacroName_m + " renamed to " + this.newMacroName_m + " by " + this.appName_m;
                    ContentManager.savePageVersion(content, this.user_m, versionComment, newBody, false, true);
                }
                searchResults = ContentManager.nextSearch(searchResults);
            }
        }
        catch (Exception e) {
            this.logger_m.error("Error renaming macro: " + e.getMessage());
        }
        this.logger_m.info("Process Complete");
    }

    @Nullable
    public String replaceMacroName(String pageBody) {
        MacroRenamer renamer = new MacroRenamer();
        try {
            String newBody = this.xhtmlContent_m.replaceMacroDefinitionsWithString(pageBody, this.conversionContext_m, (MacroDefinitionReplacer)renamer);
            if (renamer.modified_m) {
                return newBody;
            }
        }
        catch (Exception e) {
            this.logger_m.error(e.getMessage());
        }
        return null;
    }

    public class MacroRenamer
    implements MacroDefinitionReplacer {
        public boolean modified_m = false;

        public String replace(MacroDefinition macroDefinition) throws XhtmlException {
            String name = macroDefinition.getName();
            Map params = macroDefinition.getParameters();
            Map typedParams = macroDefinition.getTypedParameters();
            if (name.equalsIgnoreCase(MacroRenameProcess.this.oldMacroName_m) && (MacroRenameProcess.this.paramExist_m == null || params.containsKey(MacroRenameProcess.this.paramExist_m))) {
                macroDefinition.setName(MacroRenameProcess.this.newMacroName_m);
                if (MacroRenameProcess.this.replaceValues_m != null) {
                    for (Triplet entry : MacroRenameProcess.this.replaceValues_m) {
                        String key = (String)entry.getA();
                        if (!params.containsKey(key)) continue;
                        String value = (String)params.get(key);
                        value = value.replace((CharSequence)entry.getB(), (CharSequence)entry.getC());
                        params.put(key, value);
                        typedParams.put(key, value);
                    }
                    macroDefinition.setTypedParameters(typedParams);
                    macroDefinition.setParameters(params);
                }
                if (MacroRenameProcess.this.addParams_m != null) {
                    for (Triplet entry : MacroRenameProcess.this.addParams_m) {
                        params.put((String)entry.getA(), (String)entry.getB());
                        typedParams.put((String)entry.getA(), entry.getB());
                    }
                    macroDefinition.setTypedParameters(typedParams);
                    macroDefinition.setParameters(params);
                }
                this.modified_m = true;
            }
            return MacroRenameProcess.this.xhtmlContent_m.convertMacroDefinitionToStorage(macroDefinition, MacroRenameProcess.this.conversionContext_m);
        }
    }
}

