/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.ConfluenceDCChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DataCenterCondition
extends BaseConfluenceCondition {
    public final PluginLicenseManager pluginLicenseManager_m;
    public final PluginAccessor pluginAccessor_m;
    private final ConfluenceDCChecker confluenceDCChecker_m;
    private final Logger logger_m = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    @Inject
    public DataCenterCondition(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginAccessor pluginAccessor, ConfluenceDCChecker confluenceDCChecker) {
        this.pluginLicenseManager_m = pluginLicenseManager;
        this.pluginAccessor_m = pluginAccessor;
        this.confluenceDCChecker_m = confluenceDCChecker;
    }

    public boolean shouldDisplay(WebInterfaceContext context) {
        return this.confluenceDCChecker_m.isDataCenter() || this.isDebug();
    }

    private boolean isDebug() {
        Plugin plugin = this.pluginAccessor_m.getPlugin(this.pluginLicenseManager_m.getPluginKey());
        Map params = plugin.getPluginInformation().getParameters();
        if (params.containsKey("kentcom-debug")) {
            return ((String)params.get("kentcom-debug")).contains("debug");
        }
        return false;
    }
}

