(function ($) {
    // this closure helps us keep our variables to ourselves.
    // This pattern is known as an "iife" - immediately invoked function expression
    // wait for the DOM (i.e., document "skeleton") to load. This likely isn't necessary for the current case,
    // but may be helpful for AJAX that provides secondary content.
    $(document).ready(function()
    {
        // We want to render the Dialogs from Soy templates on the page so we can show() it when needed
        AJS.$("#main").after(EasyForums.Templates.Soy.statusDeleteVerify());
        AJS.$("#main").after(EasyForums.Templates.Soy.efMessageDiv());

        // form the URL
        var url = AJS.params.contextPath + "/plugins/servlet/easyforums/configuration";
        var restUrl = AJS.params.contextPath + "/rest/easyforums/1.0";

        function handleError(error, message)
        {
            if(!message)
            {
                if (error == 503) {
                    // DC read-only mode....
                    message = "Confluence is in READ-ONLY mode, this action is not available";
                } else if (error == 401) {
                    // unauthorised, we don't need to display a message here....
                    return;
                } else if (error == 402) {  // payment req
                    // license error
                    message = AJS.I18n.getText("net.kentcom.easy-forums.unlicensed");
                } else {
                    // 400 bad request, should not happen
                    message = "Internal Server error, contact Administrator and refer to logs";
                }
            }
            console.log(error);

            AJS.messages.warning("#efMessageDiv",
            {
               title: AJS.I18n.getText("net.kentcom.easy-forums.plugin.name"),
               body: message,
               closeable: true,
               fadeout: true,
               delay  : 5000
            });
        }

        // request the config information from the server
        $.ajax({
            url: url,
            type: "GET",
            data:
            {
                grab:       "configuration",
                atl_token:  AJS.Meta.get("atl-token")
            },
            dataType: "json",
        }).done(function(config) { // when the configuration is returned...
            // ...populate the form.
            $("#easyforums-showAvatar").prop("checked", config.showAvatar);
            $("#easyforums-renderTablesOnly").prop("checked", config.renderTablesOnly);
            $("#easyforums-showTopContributors").prop("checked", config.showTopContributors);
            $("#easyforums-maxTableItems").val(config.maxTableItems);
            $("#easyforums-showPageViews").prop("checked", config.showPageViews);
            $("#easyforums-defaultSortColumn").val(config.defaultSortColumn);
            $("#easyforums-showLabels").prop("checked", config.showLabels);
            $("#easyforums-showSidebar").prop("checked", config.showSidebar);
            $("#easyforums-maxForumModerators").val(config.maxForumModerators);

            $.each(config.templates, function (i, option) {
                $("#easyforums-forumTemplate").append('<option>'+option+'</option>');
            });
            $("#easyforums-forumTemplate").val(config.forumTemplate);
        });

        // request User status list
        console.log("Getting User Status");
        $.ajax({
            url: url,
            type: "GET",
            data:
            {
                grab:       "user_status",
                atl_token:  AJS.Meta.get("atl-token")
            },
            dataType: "html",
        }).done(function(text) { // when the configuration is returned...
            // ...populate the table
            document.getElementById("easyforums-user-status-fields").innerHTML = text;
        });

        function updateConfig()
        {
            $.ajax({
                url: url,
                type: "POST",
                data:
                {
                    store:              "configuration",
                    showAvatar:         AJS.$("#easyforums-showAvatar").is(':checked'),
                    renderTablesOnly:   AJS.$("#easyforums-renderTablesOnly").is(':checked'),
                    forumTemplate:      AJS.$("#easyforums-forumTemplate").val(),
                    showTopContributors:AJS.$("#easyforums-showTopContributors").is(':checked'),
                    maxTableItems:      AJS.$("#easyforums-maxTableItems").val(),
                    showPageViews:      AJS.$("#easyforums-showPageViews").is(':checked'),
                    defaultSortColumn:  AJS.$("#easyforums-defaultSortColumn").val(),
                    showLabels:         AJS.$("#easyforums-showLabels").is(':checked'),
                    showSidebar:        AJS.$("#easyforums-showSidebar").is(':checked'),
                    maxForumModerators: AJS.$("#easyforums-maxForumModerators").val(),
                    atl_token:          AJS.Meta.get("atl-token")
                }
             }).success(function() {
                $("#easyforums-success").show();
             }).error(function(jqXHR) {
                handleError(jqXHR.status, jqXHR.responseText);
             });
        }

        AJS.$("#easyforums-admin").submit(function(e) {
            e.preventDefault();
            updateConfig();
        });

        function hideSuccess()
        {
            $("#easyforums-success").hide();
        };

        AJS.$(".easyforums-input").change(function(e) {
            hideSuccess();
        });

        AJS.$("#easyforums-setup-moderators").click(function(e) {
            e.preventDefault();
            window.location.href = AJS.params.contextPath + "/admin/users/domembersofgroupsearch.action?membersOfGroupTerm=easyforums-moderators";
        });

        function modifyUserStatus(oldValue, newValue)
        {
            $.ajax({
                url: url,
                type: "POST",
                data:
                {
                    store:    "user_status",
                    action:   "modify",
                    oldValue:  oldValue,
                    newValue:  newValue,
                    atl_token: AJS.Meta.get("atl-token")
                }
            }).success(function(html) {
                console.log(html);
                if(html.length > 0)
                {
                    // it was deleted, replace table
                    document.getElementById("easyforums-user-status-fields").innerHTML = html;
                }
            }).error(function(jqXHR) {
               handleError(jqXHR.status, jqXHR.responseText);
            });
        }

        var deleteValue;
        function deleteUserStatus()
        {
            $.ajax({
                url: url,
                type: "POST",
                data:
                {
                    store:    "user_status",
                    action:   "delete",
                    value:    deleteValue,
                    atl_token:AJS.Meta.get("atl-token")
                }
            }).success(function(html) {
                if(html.length > 0)
                {
                    // it was deleted, replace table
                    document.getElementById("easyforums-user-status-fields").innerHTML = html;
                }
            }).error(function(jqXHR) {
              handleError(jqXHR.status, jqXHR.responseText);
            });
        }

        function addUserStatus(value)
        {
            $.ajax({
                url: url,
                type: "POST",
                data:
                {
                    store:    "user_status",
                    action:   "add",
                    value:    AJS.$('#ef-admin-field-addnew').val(),
                    atl_token: AJS.Meta.get("atl-token")
                }
            }).success(function(html) {
                if(html.length > 0)
                {
                    // it was added, replace table
                    document.getElementById("easyforums-user-status-fields").innerHTML = html;
                }
            }).error(function(jqXHR) {
                handleError(jqXHR.status, jqXHR.responseText);
            });
        }

        // handle add new entry
        $(document).on('change keyup input paste', '#ef-admin-field-addnew', function(e)
        {
            AJS.$("#ef-admin-add-status").prop('disabled', false);
        });

        // handle Add button click
        $(document).on('click', '#ef-admin-add-status', function(e)
        {
            e.preventDefault();
            addUserStatus();
        });

        // handle Delete button click
        $(document).on('click', '.ef-admin-delete-status', function(e)
        {
            e.preventDefault();
            deleteValue = $(this).attr('value');
            // Show Delete warning dialog
            AJS.dialog2("#easy-forums-status-delete").show();
        });

        $(document).on('click', '#delete-verify-delete', function(e)
        {
            e.preventDefault();
            AJS.dialog2("#easy-forums-status-delete").hide();
            deleteUserStatus();
        });

        $(document).on('click', '#delete-verify-close', function(e)
         {
             e.preventDefault();
             AJS.dialog2("#easy-forums-status-delete").hide();
         });

        // handle Modify button click
        $(document).on('change keyup input paste', '.ef-admin-field-value', function(e)
        {
            AJS.$("#" + $(this).attr('buttonid')).prop('disabled', false);
        });
        $(document).on('click', '.ef-admin-modify-button', function(e)
        {
            e.preventDefault();
            var newValue = AJS.$("#" + $(this).attr('elementid')).val();
            modifyUserStatus($(this).attr('value'),newValue);
        });

        // Debugging facilities, to show the export button
        var lastKeyCode = 0;
        $(document).on('keydown', function(e)
        {
            if(e.keyCode == 17)
            {
                // CRTL key pressed, twice in succession
                if(lastKeyCode == 17)
                {
                    // show our debugging div
                    $('#easy-forums-debugging').show();
                }
                // reset lastKeyCode
                setTimeout(function() {lastKeyCode = 0;}, 400);
            }
            lastKeyCode = e.keyCode;
        });

        $(document).on('click', '#easyforums-export-data', function(e)
        {
            var button = this;
            $('#easyforums-export-result').html("");
            console.log("Export Data started");
            $(button).prop('disabled', true);
            button.busy();
            e.preventDefault();
            $.ajax({
                url: restUrl + "/admin/export/ao",
                type: "GET"
            }).success(function(data) {
                // may need some progress?
                console.log("Export Data finished");
                $(button).prop('disabled', false);
                button.idle();
                $('#easyforums-export-result').html(data);
           }).error(function(jqXHR, status, error) {
              handleError(jqXHR.status);
           });
        });

        $(document).on('click', '#easyforums-upgrade-data', function(e)
        {
            var button = this;
            $('#easyforums-upgrade-result').html("");
            console.log("Upgrade Data started");
            $(button).prop('disabled', true);
            button.busy();
            e.preventDefault();
            $.ajax({
                url: restUrl + "/admin/upgrade",
                type: "POST",
                data:
                {
                    atl_token: AJS.Meta.get("atl-token")
                }
            }).success(function(data) {
                // may need some progress?
                console.log("Upgrade Data finished");
                $(button).prop('disabled', false);
                button.idle();
                $('#easyforums-upgrade-result').html(data);
           }).error(function(jqXHR, status, error) {
              handleError(jqXHR.status);
           });
        });

    });

})(AJS.$ || jQuery);
