/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.servlets;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.ForumDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTopicCreatorsServlet
extends HttpServlet {
    private final ForumDataService forumDataService_m;
    private final I18nResolver i18nResolver_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(SetTopicCreatorsServlet.class);

    @Inject
    public SetTopicCreatorsServlet(@ComponentImport I18nResolver i18nResolver, ConfluenceUtilities confluenceUtilities, ForumDataService forumDataService) {
        this.forumDataService_m = forumDataService;
        this.i18nResolver_m = i18nResolver;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(503);
            return;
        }
        String pageId = request.getParameter("pageId");
        String groupName = request.getParameter("groupName");
        this.logger_m.info("pageId: " + pageId + " Group: " + groupName);
        String defaultCreators = this.i18nResolver_m.getText("net.kentcom.easy-forums.moderators.forum.default");
        if (groupName.equals(defaultCreators)) {
            this.forumDataService_m.setTopicCreatorsGroup(pageId, "");
        } else {
            this.forumDataService_m.setTopicCreatorsGroup(pageId, groupName);
        }
        response.setStatus(200);
    }
}

