/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.servlets;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.easyforums.ForumConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchAdminPageServlet
extends HttpServlet {
    private final UserManager userManager_m;
    private final LoginUriProvider loginUriProvider_m;
    private final TemplateRenderer templateRenderer_m;
    private final AppConfigSettings appConfigSettings_m;
    private final Logger logger_m = LoggerFactory.getLogger(LaunchAdminPageServlet.class);

    @Inject
    public LaunchAdminPageServlet(@ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer, AppConfigSettings appConfigSettings) {
        this.userManager_m = userManager;
        this.loginUriProvider_m = loginUriProvider;
        this.templateRenderer_m = templateRenderer;
        this.appConfigSettings_m = appConfigSettings;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile user = this.userManager_m.getRemoteUser(request);
        if (user == null || !this.userManager_m.isAdmin(user.getUserKey())) {
            this.redirectToLogin(request, response);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        Map context = MacroUtils.defaultVelocityContext();
        context.put("showAvatars", (Boolean)this.appConfigSettings_m.getSetting(ForumConstants.showAvatar_m) != false ? "checked" : "");
        context.put("maxTableItems", this.appConfigSettings_m.getSetting(ForumConstants.maxTableItems_m));
        context.put("upgradeStatus", this.appConfigSettings_m.getSetting(ForumConstants.upgradeStatus_m));
        this.templateRenderer_m.render("templates/easy-forums/admin.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider_m.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

