/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.ForumDataService;
import net.kentcom.easyforums.ForumUtilities;
import net.kentcom.easyforums.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPageMacro
implements Macro {
    private final LikeManager likeManager_m;
    private final AppConfigSettings appConfigSetting_m;
    private final XhtmlContent xhtmlContent_m;
    private final PermissionManager permissionManager_m;
    private final I18nResolver i18nResolver_m;
    private final ForumUtilities forumUtilities_m;
    private final LicenseCheck licenseCheck_m;
    private final StatusType statusType_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final ForumDataService forumDataService_m;
    private final PageBuilderService pageBuilderService_m;
    private final VelocityHelperService velocityHelperService_m;
    private final Logger logger_m = LoggerFactory.getLogger(TopicPageMacro.class);
    private static Long usageCount_m = 0L;

    @Inject
    public TopicPageMacro(@ComponentImport LikeManager likeManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport PermissionManager permissionManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport VelocityHelperService velocityHelperService, AppConfigSettings appConfigSetting, ForumUtilities forumUtilities, ForumDataService forumDataService, LicenseCheck licenseCheck, StatusType statusType, ConfluenceUtilities confluenceUtilities) {
        this.likeManager_m = likeManager;
        this.xhtmlContent_m = xhtmlContent;
        this.permissionManager_m = permissionManager;
        this.i18nResolver_m = i18nResolver;
        this.appConfigSetting_m = appConfigSetting;
        this.forumUtilities_m = forumUtilities;
        this.licenseCheck_m = licenseCheck;
        this.statusType_m = statusType;
        this.confluenceUtilities_m = confluenceUtilities;
        this.pageBuilderService_m = pageBuilderService;
        this.velocityHelperService_m = velocityHelperService;
        this.forumDataService_m = forumDataService;
    }

    public static Long getUsageCount() {
        Long temp = usageCount_m;
        usageCount_m = 0L;
        return temp;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        boolean showLabels;
        if (conversionContext.hasProperty(TopicPageMacro.class.getName())) {
            return "";
        }
        conversionContext.setProperty(TopicPageMacro.class.getName(), (Object)true);
        if (!this.licenseCheck_m.isLicenseOK("net.kentcom.easy-forums")) {
            return this.confluenceUtilities_m.warningMessage(this.i18nResolver_m.getText("net.kentcom.easy-forums.plugin.name"), this.i18nResolver_m.getText("net.kentcom.easy-forums.unlicensed"), conversionContext);
        }
        this.pageBuilderService_m.assembler().resources().requireWebResource("net.kentcom.easy-forums:easy-forums-resources");
        Long l = usageCount_m;
        usageCount_m = usageCount_m + 1L;
        StringBuilder builder = new StringBuilder();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Page page = (Page)conversionContext.getEntity();
        Page parent = page.getParent();
        boolean isUserModerator = this.forumUtilities_m.isUserModerator(user, parent.getIdAsString());
        boolean isUserAdministrator = this.confluenceUtilities_m.isUserAdministrator(user, conversionContext.getSpaceKey());
        boolean isUserPageOwner = page.getCreator() != null && page.getCreator().equals(user);
        try {
            showLabels = (Boolean)this.appConfigSetting_m.getSetting(ForumConstants.showLabels_m);
        }
        catch (Exception e) {
            showLabels = Boolean.parseBoolean((String)this.appConfigSetting_m.getSetting(ForumConstants.showLabels_m));
        }
        int maxLikes = 0;
        Comment mostPopComment = null;
        List mostPopLikes = null;
        String heartUrl = "download/resources/net.kentcom.easy-forums:easy-forums-resources/images/heart.png";
        String thumbUrl = "download/resources/net.kentcom.easy-forums:easy-forums-resources/images/thumb-up.png";
        SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy");
        List comments = page.getComments();
        for (Comment comment : comments) {
            List likes = this.likeManager_m.getLikes((ContentEntityObject)comment);
            int count = likes.size();
            if (count <= maxLikes && mostPopComment != null) continue;
            mostPopComment = comment;
            mostPopLikes = likes;
            maxLikes = count;
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("numLikes", maxLikes);
        context.put("heartUrl", heartUrl);
        context.put("thumbUrl", thumbUrl);
        context.put("showAvatar", this.appConfigSetting_m.getSetting(ForumConstants.showAvatar_m));
        context.put("youLike", false);
        context.put("noAnswer", true);
        if (mostPopComment != null) {
            context.put("noAnswer", false);
            context.put("mostPopId", mostPopComment.getIdAsString());
            context.put("avatarWithHtml", this.confluenceUtilities_m.getImageUrlString(mostPopComment.getLastModifier(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")) + "  ");
            try {
                context.put("lastModifier", mostPopComment.getLastModifier().getFullName());
            }
            catch (Exception e) {
                context.put("lastModifier", this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous"));
            }
            context.put("lastModDate", dateFormat.format(mostPopComment.getLastModificationDate()));
            try {
                context.put("mostPopCommentWithHtml", this.xhtmlContent_m.convertStorageToView(mostPopComment.getBodyAsString(), conversionContext));
            }
            catch (Exception e) {
                this.logger_m.error(e.toString());
            }
        }
        if (mostPopLikes != null) {
            for (Like like : mostPopLikes) {
                if (user == null || !like.getUsername().matches(user.getName())) continue;
                context.put("youLike", true);
                break;
            }
        }
        builder.append(this.velocityHelperService_m.getRenderedTemplate("templates/easy-forums/topic-macro.vm", context));
        builder.append(this.forumUtilities_m.hidePageElements(!isUserAdministrator && !isUserModerator && !isUserPageOwner, false, this.getTopicStatus(page) == StatusType.Read_Only || !this.permissionManager_m.hasCreatePermission((User)user, (Object)page, Comment.class) || !this.permissionManager_m.hasPermission((User)user, Permission.EDIT, (Object)parent), !showLabels, !isUserAdministrator && !isUserModerator, !isUserAdministrator && !isUserModerator));
        return builder.toString();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private Integer getTopicStatus(Page topic) {
        Integer statusId = this.forumDataService_m.getContentStatus(topic.getParent().getIdAsString());
        if (statusId == StatusType.Read_Only) {
            return statusId;
        }
        statusId = this.forumDataService_m.getContentStatus(topic.getIdAsString());
        if (statusId == null) {
            return StatusType.Active;
        }
        return statusId;
    }
}

