/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.ForumDataService;
import net.kentcom.easyforums.ForumUtilities;
import net.kentcom.easyforums.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForumPageMacro
implements Macro {
    private final AppConfigSettings appConfigSetting_m;
    private final PermissionManager permissionManager_m;
    private final SpaceManager spaceManager_m;
    private final UserAccessor userAccessor_m;
    private final ForumUtilities forumUtilities_m;
    private final ForumDataService forumDataService_m;
    private final LicenseCheck licenseCheck_m;
    private final StatusType statusType_m;
    private final I18nResolver i18nResolver_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final VelocityHelperService velocityHelperService_m;
    private final PageBuilderService pageBuilderService_m;
    private final Logger logger_m = LoggerFactory.getLogger(ForumPageMacro.class);
    private static Long usageCount_m = 0L;

    @Inject
    public ForumPageMacro(@ComponentImport PermissionManager permissionManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport SpaceManager spaceManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport VelocityHelperService velocityHelperService, AppConfigSettings appConfigSetting, ForumUtilities forumUtilities, ForumDataService forumDataService, LicenseCheck licenseCheck, StatusType statusType, ConfluenceUtilities confluenceUtilities) {
        this.forumDataService_m = forumDataService;
        this.permissionManager_m = permissionManager;
        this.i18nResolver_m = i18nResolver;
        this.spaceManager_m = spaceManager;
        this.userAccessor_m = userAccessor;
        this.appConfigSetting_m = appConfigSetting;
        this.forumUtilities_m = forumUtilities;
        this.licenseCheck_m = licenseCheck;
        this.statusType_m = statusType;
        this.confluenceUtilities_m = confluenceUtilities;
        this.velocityHelperService_m = velocityHelperService;
        this.pageBuilderService_m = pageBuilderService;
    }

    public static Long getUsageCount() {
        Long temp = usageCount_m;
        usageCount_m = 0L;
        return temp;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        if (conversionContext.hasProperty(ForumPageMacro.class.getName())) {
            return "";
        }
        conversionContext.setProperty(ForumPageMacro.class.getName(), (Object)true);
        if (!this.licenseCheck_m.isLicenseOK("net.kentcom.easy-forums")) {
            return this.confluenceUtilities_m.warningMessage(this.i18nResolver_m.getText("net.kentcom.easy-forums.plugin.name"), this.i18nResolver_m.getText("net.kentcom.easy-forums.unlicensed"), conversionContext);
        }
        this.pageBuilderService_m.assembler().resources().requireWebResource("net.kentcom.easy-forums:easy-forums-resources");
        Long l = usageCount_m;
        usageCount_m = usageCount_m + 1L;
        StringBuilder builder = new StringBuilder();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Space space = this.spaceManager_m.getSpace(conversionContext.getSpaceKey());
        Page page = (Page)conversionContext.getEntity();
        boolean renderTableOnly = (Boolean)this.appConfigSetting_m.getSetting(ForumConstants.renderTablesOnly_m);
        int max = (Integer)this.appConfigSetting_m.getSetting(ForumConstants.maxTableItems_m);
        Boolean showHiddenContent = this.forumDataService_m.showHiddenContent(page.getIdAsString(), user.getKey().getStringValue());
        Boolean isUserAdministrator = this.confluenceUtilities_m.isUserAdministrator(user, conversionContext.getSpaceKey());
        Boolean isUserModerator = this.forumUtilities_m.isUserModerator(user, page.getIdAsString());
        Map context = MacroUtils.defaultVelocityContext();
        context.put("isAdmin", isUserAdministrator);
        context.put("isModerator", isUserModerator);
        ArrayList groups = this.userAccessor_m.getGroupsAsList();
        if (groups == null) {
            groups = new ArrayList();
        }
        String currentGroup = this.forumDataService_m.getTopicCreatorsGroup(page.getIdAsString());
        Set<String> modKeys = this.forumDataService_m.getForumModerators(page.getIdAsString());
        ArrayList<ConfluenceUser> moderators = new ArrayList<ConfluenceUser>();
        for (String modKey : modKeys) {
            moderators.add(this.userAccessor_m.getUserByKey(new UserKey(modKey)));
        }
        context.put("checked", showHiddenContent != false ? "checked" : "");
        context.put("currentGroup", currentGroup);
        context.put("allGroups", groups);
        context.put("maxLimit", moderators.size() >= max);
        context.put("moderators", moderators);
        context.put("renderSearch", !renderTableOnly);
        context.put("searchWithHtml", this.forumUtilities_m.renderSearchBox(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.search"), conversionContext));
        if (this.canCreateTopic(user, isUserAdministrator, isUserModerator, space, page, currentGroup)) {
            context.put("createNewButtonWithHtml", this.forumUtilities_m.addCreateNewButton(this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.new"), "easy-forums-topic-blueprint", conversionContext, false));
        } else {
            context.put("createNewButtonWithHtml", "");
        }
        context.put("tableHeadings", this.forumUtilities_m.addForumColumnHeadings());
        context.put("class", "ef-forum-heading");
        context.put("tableData", this.forumUtilities_m.createListOfTopics(page, user, isUserAdministrator, isUserModerator, max, showHiddenContent));
        builder.append(this.velocityHelperService_m.getRenderedTemplate("templates/easy-forums/forum-page-macro.vm", context));
        builder.append(this.forumUtilities_m.hidePageElements(isUserAdministrator == false && isUserModerator == false, true, false, true, isUserAdministrator == false && isUserModerator == false, isUserAdministrator == false && isUserModerator == false));
        return builder.toString();
    }

    private boolean canCreateTopic(ConfluenceUser user, boolean isUserAdministrator, boolean isUserModerator, Space space, Page page, String topicCreators) {
        int forumStatus = this.forumDataService_m.getContentStatus(page.getIdAsString());
        if (forumStatus == StatusType.Read_Only) {
            return false;
        }
        if (isUserAdministrator || isUserModerator) {
            return true;
        }
        if (topicCreators == null) {
            return this.permissionManager_m.hasCreatePermission((User)user, (Object)space, Page.class) && this.permissionManager_m.hasPermission((User)user, Permission.EDIT, (Object)page);
        }
        return this.confluenceUtilities_m.isUserInGroup(user, topicCreators);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

