/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.ForumDataService;
import net.kentcom.easyforums.ForumUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForumHomePageMacro
implements Macro {
    private final SettingsManager settingsManager_m;
    private final ForumUtilities forumUtilities_m;
    private final AppConfigSettings appConfigSetting_m;
    private final I18nResolver i18nResolver_m;
    private final LicenseCheck licenseCheck_m;
    private final VelocityHelperService velocityHelperService_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final PageBuilderService pageBuilderService_m;
    private final ForumDataService forumDataService_m;
    private final Logger logger_m = LoggerFactory.getLogger(ForumHomePageMacro.class);
    private static Long usageCount_m = 0L;

    @Inject
    public ForumHomePageMacro(@ComponentImport SettingsManager settingsManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport VelocityHelperService velocityHelperService, AppConfigSettings appConfigSetting, ForumUtilities forumUtilities, ForumDataService forumDataService, LicenseCheck licenseCheck, ConfluenceUtilities confluenceUtilities) {
        this.settingsManager_m = settingsManager;
        this.i18nResolver_m = i18nResolver;
        this.appConfigSetting_m = appConfigSetting;
        this.forumUtilities_m = forumUtilities;
        this.licenseCheck_m = licenseCheck;
        this.confluenceUtilities_m = confluenceUtilities;
        this.velocityHelperService_m = velocityHelperService;
        this.pageBuilderService_m = pageBuilderService;
        this.forumDataService_m = forumDataService;
    }

    public static Long getUsageCount() {
        Long temp = usageCount_m;
        usageCount_m = 0L;
        return temp;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        if (conversionContext.hasProperty(ForumHomePageMacro.class.getName())) {
            return "";
        }
        conversionContext.setProperty(ForumHomePageMacro.class.getName(), (Object)true);
        if (!this.licenseCheck_m.isLicenseOK("net.kentcom.easy-forums")) {
            return this.confluenceUtilities_m.warningMessage(this.i18nResolver_m.getText("net.kentcom.easy-forums.plugin.name"), this.i18nResolver_m.getText("net.kentcom.easy-forums.unlicensed"), conversionContext);
        }
        this.pageBuilderService_m.assembler().resources().requireWebResource("net.kentcom.easy-forums:easy-forums-resources");
        Long l = usageCount_m;
        usageCount_m = usageCount_m + 1L;
        StringBuilder builder = new StringBuilder();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Page page = (Page)conversionContext.getEntity();
        boolean renderTableOnly = (Boolean)this.appConfigSetting_m.getSetting(ForumConstants.renderTablesOnly_m);
        int max = (Integer)this.appConfigSetting_m.getSetting(ForumConstants.maxTableItems_m);
        Boolean showHiddenContent = this.forumDataService_m.showHiddenContent(page.getIdAsString(), user.getKey().getStringValue());
        Boolean isUserAdministrator = this.confluenceUtilities_m.isUserAdministrator(user, conversionContext.getSpaceKey());
        Boolean isUserModerator = this.forumUtilities_m.isUserModerator(user, page.getIdAsString());
        Map context = MacroUtils.defaultVelocityContext();
        context.put("isAdmin", isUserAdministrator);
        context.put("isModerator", isUserModerator);
        context.put("checked", showHiddenContent != false ? "checked" : "");
        context.put("renderSearch", !renderTableOnly);
        context.put("searchWithHtml", this.forumUtilities_m.renderSearchBox(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.search"), conversionContext));
        context.put("contactModeratorsWithHtml", this.addModerators());
        context.put("createNewButtonWithHtml", this.forumUtilities_m.addCreateNewButton(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.new"), "easy-forums-forum-blueprint", conversionContext, true));
        context.put("editSpaceButtonWithHtml", this.addEditSpaceButton(conversionContext.getSpaceKey()));
        context.put("tableHeadings", this.forumUtilities_m.addForumHomeColumnHeadings());
        context.put("class", "ef-summary-heading");
        context.put("tableData", this.forumUtilities_m.createListOfForums(page, user, isUserAdministrator, isUserModerator, max, showHiddenContent));
        builder.append(this.velocityHelperService_m.getRenderedTemplate("templates/easy-forums/forum-home-page-macro.vm", context));
        builder.append(this.forumUtilities_m.hidePageElements(isUserAdministrator == false && isUserModerator == false, true, false, true, isUserAdministrator == false && isUserModerator == false, isUserAdministrator == false && isUserModerator == false));
        return builder.toString();
    }

    private String addModerators() {
        List<String> moderators = this.confluenceUtilities_m.getUsersInGroup(ForumConstants.moderatorGroupName_m);
        StringBuilder names = new StringBuilder();
        StringBuilder emails = new StringBuilder();
        if (moderators.size() == 0) {
            names.append("<font color=\"red\"><b>");
            names.append(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.unknown", new Serializable[]{ForumConstants.moderatorGroupName_m}));
            names.append("</b></font> ");
        } else {
            for (String moderator : moderators) {
                names.append(this.confluenceUtilities_m.getFullName(moderator));
                names.append(", ");
                emails.append(this.confluenceUtilities_m.getEmail(moderator));
                emails.append(";");
            }
        }
        return "<p class=\"ef-text-centre\">" + this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.moderators", new Serializable[]{names, "<a href=\"mailto:" + emails + "\" class=\"external-link\" rel=\"nofollow\">email</a>"}) + "</p><br>";
    }

    private String addEditSpaceButton(String spaceKey) {
        return "<a href=\"" + this.settingsManager_m.getGlobalSettings().getBaseUrl() + "/spaces/viewspacesummary.action?key=" + spaceKey + "\"><button class=\"aui-button\" style=\"float: right;\">" + this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.admin") + "</button></a>";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

