/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.servlets;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.ForumUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetModeratorsServlet
extends HttpServlet {
    private final BandanaManager bandanaManager_m;
    private final AppConfigSettings appConfigSetting_m;
    private final ForumUtilities forumUtilities_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(SetModeratorsServlet.class);

    @Inject
    public SetModeratorsServlet(@ComponentImport BandanaManager bandanaManager, ConfluenceUtilities confluenceUtilities, AppConfigSettings appConfigSetting, ForumUtilities forumUtilities) {
        this.bandanaManager_m = bandanaManager;
        this.appConfigSetting_m = appConfigSetting;
        this.forumUtilities_m = forumUtilities;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(503);
            return;
        }
        int max = (Integer)this.appConfigSetting_m.getSetting(ForumConstants.m_maxForumModerators);
        String pageId = request.getParameter("pageId");
        String action = request.getParameter("action");
        String userKey = request.getParameter("userKey");
        this.logger_m.info("pageId: " + pageId + " Action: " + action + " UserKey: " + userKey);
        ConfluenceBandanaContext modContext = new ConfluenceBandanaContext(ForumConstants.m_moderatorContentPrefix + pageId);
        List users = (List)this.bandanaManager_m.getKeys((BandanaContext)modContext);
        if (userKey.length() > 0) {
            if (action.equals("add") && users.size() < max) {
                this.bandanaManager_m.setValue((BandanaContext)modContext, userKey, (Object)"");
            } else if (action.equals("remove")) {
                this.bandanaManager_m.removeValue((BandanaContext)modContext, userKey);
            }
            response.setContentType("text/html; charset=UTF-8");
            response.getWriter().write(this.forumUtilities_m.renderForumModerators(pageId));
            response.setStatus(200);
        } else {
            response.setStatus(406);
        }
    }
}

