/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.config.Schedule;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.UsageAnalytics;
import net.kentcom.common.scheduler.SchedulerJobManager;
import net.kentcom.common.scheduler.SchedulerManager;
import net.kentcom.easyforums.EventHandler;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.StatusType;
import net.kentcom.easyforums.macros.ForumMacro;
import net.kentcom.easyforums.macros.ForumSummaryMacro;
import net.kentcom.easyforums.macros.TopicMacro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class ForumListener
implements InitializingBean,
DisposableBean,
SchedulerJobManager {
    private final EventPublisher eventPublisher_m;
    private final UsageAnalytics usageAnalytics_m;
    private final SchedulerManager schedulerManager_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final BandanaManager bandanaManager_m;
    private final NotificationManager notificationManager_m;
    private final AppConfigSettings appConfigSetting_m;
    private final LicenseCheck licenseCheck_m;
    private final LabelManager labelManager_m;
    private final UserAccessor userAccessor_m;
    private final I18nResolver i18nResolver_m;
    private final ExecutorService executorService_m;
    private final StatusType statusType_m;
    private final Logger logger_m = LoggerFactory.getLogger(ForumListener.class);
    private SummaryMap summaryHeadings_m = null;
    private ForumMap forumHeadings_m = null;

    public SummaryMap getSummaryMap() {
        if (this.summaryHeadings_m == null) {
            this.summaryHeadings_m = this.createSummaryMap();
        }
        return this.summaryHeadings_m;
    }

    public ForumMap getForumMap() {
        if (this.forumHeadings_m == null) {
            this.forumHeadings_m = this.createForumMap();
        }
        return this.forumHeadings_m;
    }

    @Inject
    public ForumListener(@ComponentImport EventPublisher eventPublisher, @ComponentImport BandanaManager bandanaManager, @ComponentImport UserAccessor userAccessor, @ComponentImport NotificationManager notificationManager, @ComponentImport LabelManager labelManager, @ComponentImport I18nResolver i18nResolver, LicenseCheck licenseCheck, ConfluenceUtilities confluenceUtilities, UsageAnalytics usageAnalytics, SchedulerManager schedulerManager, StatusType statusType, AppConfigSettings appConfigSetting) {
        this.i18nResolver_m = i18nResolver;
        this.eventPublisher_m = eventPublisher;
        this.bandanaManager_m = bandanaManager;
        this.notificationManager_m = notificationManager;
        this.labelManager_m = labelManager;
        this.userAccessor_m = userAccessor;
        this.licenseCheck_m = licenseCheck;
        this.appConfigSetting_m = appConfigSetting;
        this.confluenceUtilities_m = confluenceUtilities;
        this.usageAnalytics_m = usageAnalytics;
        this.schedulerManager_m = schedulerManager;
        this.statusType_m = statusType;
        this.executorService_m = Executors.newFixedThreadPool(50);
    }

    public void afterPropertiesSet() throws Exception {
        this.logger_m.info("afterPropertiesSet");
        ConfluenceUtilities.enableLogging();
        this.eventPublisher_m.register((Object)this);
        this.schedulerManager_m.initialise(this, "net.kentcom.easy-forums");
    }

    public void destroy() throws Exception {
        this.eventPublisher_m.unregister((Object)this);
        this.executorService_m.shutdown();
        this.schedulerManager_m.destroy();
    }

    @PluginEventListener
    public void pluginEnabledEvent(PluginEnabledEvent event) {
        if (event.getPlugin().getKey().equals("net.kentcom.easy-forums")) {
            this.logger_m.info("_____ Detected our pluginEnabledEvent _____");
            if (this.userAccessor_m.getGroup(ForumConstants.m_moderatorGroupName) == null) {
                try {
                    ConfluenceUser admin = this.confluenceUtilities_m.getUser(this.confluenceUtilities_m.getAdminUser());
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
                    this.userAccessor_m.createGroup(ForumConstants.m_moderatorGroupName);
                    AuthenticatedUserThreadLocal.reset();
                }
                catch (Exception e) {
                    this.logger_m.error(e.getMessage());
                    this.logger_m.error("Unable to create Confluence Group \"" + ForumConstants.m_moderatorGroupName + "\" please create this Confluence Group Manually");
                }
            }
            this.logger_m.info("License Valid: {}", (Object)this.licenseCheck_m.isLicenseOK("net.kentcom.easy-forums"));
            this.appConfigSetting_m.initialise(ForumConstants.m_bandanaContextStr, "net.kentcom.easy-forums", "Easy Forums");
            this.appConfigSetting_m.addSetting(ForumConstants.m_pluginVersion, this.licenseCheck_m.getPluginVersion());
            this.appConfigSetting_m.addSetting(ForumConstants.m_showAvatar, Boolean.TRUE);
            this.appConfigSetting_m.addSetting(ForumConstants.m_renderTablesOnly, Boolean.FALSE);
            this.appConfigSetting_m.addSetting(ForumConstants.m_forumTemplate, "EasyForums-Forum");
            this.appConfigSetting_m.addSetting(ForumConstants.m_maxTableItems, 100);
            this.appConfigSetting_m.addSetting(ForumConstants.m_defaultSortColumn, ForumConstants.SummaryColumns.LAST_POST.name());
            this.appConfigSetting_m.addSetting(ForumConstants.m_showLabels, Boolean.FALSE);
            this.appConfigSetting_m.addSetting(ForumConstants.m_showSidebar, Boolean.FALSE);
            this.appConfigSetting_m.addSetting(ForumConstants.m_maxForumModerators, 3);
            this.getSummaryMap();
            this.getForumMap();
            Label label = this.labelManager_m.getLabel(ForumConstants.m_forumLabelStr);
            ForumConstants.m_forumLabel = label == null ? this.labelManager_m.createLabel(new Label(ForumConstants.m_forumLabelStr)) : label;
            label = this.labelManager_m.getLabel(ForumConstants.m_topicLabelStr);
            ForumConstants.m_topicLabel = label == null ? this.labelManager_m.createLabel(new Label(ForumConstants.m_topicLabelStr)) : label;
            this.statusType_m.initialise();
            this.sendAnalytics();
        }
    }

    @EventListener
    public void onPageViewEvent(PageViewEvent event) {
        EventHandler handler = new EventHandler(event, this.bandanaManager_m);
        this.executorService_m.execute(handler);
    }

    @EventListener
    public void commentCreateEvent(CommentCreateEvent event) {
        this.logger_m.info("commentCreateEvent");
        EventHandler handler = new EventHandler(event, this.bandanaManager_m);
        this.executorService_m.execute(handler);
    }

    @EventListener
    public void commentUpdateEvent(CommentUpdateEvent event) {
        EventHandler handler = new EventHandler(event, this.bandanaManager_m);
        this.executorService_m.execute(handler);
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        EventHandler handler = new EventHandler(event, this.bandanaManager_m);
        this.executorService_m.execute(handler);
    }

    @EventListener
    public void onBlueprintCreateEvent(BlueprintPageCreateEvent event) {
        this.logger_m.info("onBlueprintCreateEvent");
        EventHandler handler = new EventHandler(event, this.bandanaManager_m, this.notificationManager_m, this.labelManager_m);
        this.executorService_m.execute(handler);
    }

    private SummaryMap createSummaryMap() {
        SummaryMap myMap = new SummaryMap();
        for (ForumConstants.SummaryColumns col : ForumConstants.SummaryColumns.values()) {
            this.logger_m.info("getText");
            String colName = col.name();
            this.appConfigSetting_m.addSetting("EF-Summary-" + colName, true);
            myMap.put(col, new ColumnAttributes(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.column." + colName), (Boolean)this.appConfigSetting_m.getSetting("EF-Summary-" + colName)));
        }
        return myMap;
    }

    private ForumMap createForumMap() {
        ForumMap myMap = new ForumMap();
        for (ForumConstants.ForumColumns col : ForumConstants.ForumColumns.values()) {
            this.logger_m.info("getText");
            String colName = col.name();
            this.appConfigSetting_m.addSetting("EF-Forum-" + colName, true);
            myMap.put(col, new ColumnAttributes(this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.column." + colName), (Boolean)this.appConfigSetting_m.getSetting("EF-Forum-" + colName)));
        }
        return myMap;
    }

    public void updateForumMap(ForumConstants.ForumColumns column, Boolean visible) {
        ForumMap forumMap = this.getForumMap();
        ColumnAttributes attr = (ColumnAttributes)forumMap.get((Object)column);
        attr.setVisible(visible);
        forumMap.put(column, attr);
        this.appConfigSetting_m.setSetting("EF-Forum-" + column.name(), visible);
    }

    public void updateSummaryMap(ForumConstants.SummaryColumns column, Boolean visible) {
        SummaryMap summaryMap = this.getSummaryMap();
        ColumnAttributes attr = (ColumnAttributes)summaryMap.get((Object)column);
        attr.setVisible(visible);
        summaryMap.put(column, attr);
        this.appConfigSetting_m.setSetting("EF-Summary-" + column.name(), visible);
    }

    private void sendAnalytics() {
        this.usageAnalytics_m.sendPluginInfo();
        this.usageAnalytics_m.sendMacroUsage("most-popular-comment", null);
        this.usageAnalytics_m.sendMacroUsage("forum", null);
        this.usageAnalytics_m.sendMacroUsage("topic", null);
        this.usageAnalytics_m.sendEventMetrics("ForumHomeMacro_Rendered", ForumSummaryMacro.getUsageCount());
        this.usageAnalytics_m.sendEventMetrics("ForumPageMacro_Rendered", ForumMacro.getUsageCount());
        this.usageAnalytics_m.sendEventMetrics("TopicPageMacro_Rendered", TopicMacro.getUsageCount());
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(10, 24);
        this.schedulerManager_m.schedule(Schedule.runOnce((Date)tomorrow.getTime()), null);
    }

    @Override
    public void processSchedulerJob(JobRunnerRequest request) {
        this.sendAnalytics();
    }

    public class ForumMap
    extends HashMap<ForumConstants.ForumColumns, ColumnAttributes> {
    }

    public class SummaryMap
    extends HashMap<ForumConstants.SummaryColumns, ColumnAttributes> {
    }

    public class ColumnAttributes {
        private String Name_m;
        private Boolean Visible_m;

        ColumnAttributes(String Name, Boolean Visible) {
            this.Name_m = Name;
            this.Visible_m = Visible;
        }

        public String Name() {
            return this.Name_m;
        }

        public Boolean isVisible() {
            return this.Visible_m;
        }

        public void setVisible(Boolean visible) {
            this.Visible_m = visible;
        }
    }
}

