/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.common;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.segment.analytics.Analytics;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.TrackMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.ConfluenceDCChecker;
import net.kentcom.common.ConfluenceUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

@Named
public class UsageAnalytics {
    private final PageTemplateManager pageTemplateManager_m;
    private final ConfluenceDCChecker confluenceDCChecker_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final CQLSearchService cqlSearchService_m;
    private final String pluginVersion_m;
    private final String pluginName_m;
    private final String confluenceVersion_m;
    private final String clientId_m;
    private Analytics analytics_m = null;
    private final String licenseType_m;
    private final Boolean evaluation_m;
    private final Boolean active_m;
    private final String SEN_m;
    private final Boolean inDebug_m;
    private final Logger logger_m = LoggerFactory.getLogger(UsageAnalytics.class);

    @Inject
    public UsageAnalytics(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport CQLSearchService cqlSearchService, @ComponentImport BandanaManager bandanaManager, @ComponentImport PageTemplateManager pageTemplateManager, ConfluenceUtilities confluenceUtilities, ConfluenceDCChecker confluenceDCChecker) {
        this.cqlSearchService_m = cqlSearchService;
        this.confluenceUtilities_m = confluenceUtilities;
        this.confluenceDCChecker_m = confluenceDCChecker;
        this.pageTemplateManager_m = pageTemplateManager;
        this.confluenceVersion_m = GeneralUtil.getVersionNumber();
        this.analytics_m = Analytics.builder((String)"Xmj0swGvn1jMvgCAV6SzdSQXFoFj2Cta").build();
        if (pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)pluginLicenseManager.getLicense().get();
            this.licenseType_m = license.getLicenseType().name();
            this.evaluation_m = license.isEvaluation();
            this.active_m = license.isActive();
            this.SEN_m = license.getSupportEntitlementNumber().isDefined() ? (String)license.getSupportEntitlementNumber().get() : "undefined";
        } else {
            this.licenseType_m = "NOT_LICENSED";
            this.evaluation_m = false;
            this.active_m = false;
            this.SEN_m = "undefined";
        }
        String pluginKey = pluginLicenseManager.getPluginKey();
        Plugin plugin = pluginAccessor.getPlugin(pluginKey);
        this.pluginVersion_m = plugin.getPluginInformation().getVersion();
        this.pluginName_m = plugin.getName();
        Map params = plugin.getPluginInformation().getParameters();
        this.inDebug_m = params.containsKey("kentcom-debug") ? Boolean.valueOf(((String)params.get("kentcom-debug")).contains("debug")) : Boolean.valueOf(false);
        this.clientId_m = this.getSavedClientId(bandanaManager);
    }

    private String getSavedClientId(BandanaManager bandanaManager) {
        if (this.inDebug_m.booleanValue()) {
            return "net.kentcom.developer";
        }
        ConfluenceBandanaContext context = new ConfluenceBandanaContext("net.kentcom");
        String clientId = (String)bandanaManager.getValue((BandanaContext)context, "ua-clientId");
        if (clientId == null) {
            clientId = UUID.randomUUID().toString();
            bandanaManager.setValue((BandanaContext)context, "clientId", (Object)clientId);
        }
        return clientId;
    }

    public void sendPluginInfo() {
        if (this.confluenceDCChecker_m.hasCurrentNodeLowestId()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("confluence_version", this.confluenceVersion_m);
            properties.put("plugin_version", this.pluginVersion_m);
            properties.put("sen", this.SEN_m);
            properties.put("license_type", this.licenseType_m);
            properties.put("is_evaluation", this.evaluation_m.toString());
            properties.put("license_active", this.active_m.toString());
            properties.put("is_datacenter", String.valueOf(this.confluenceDCChecker_m.isDataCenter()));
            properties.put("plugin_name", this.pluginName_m);
            properties.put("client_id", this.clientId_m);
            this.analytics_m.enqueue((MessageBuilder)((TrackMessage.Builder)TrackMessage.builder((String)"plugin_info").userId(this.clientId_m)).properties(properties));
        }
    }

    private Integer countMacroUsageInTemplates(String macroKey) {
        String find = String.format("ac:name=\"%s\"", macroKey);
        int count = 0;
        for (Object template : this.pageTemplateManager_m.getGlobalPageTemplates()) {
            PageTemplate pt = template instanceof PageTemplate ? (PageTemplate)template : null;
            if (pt == null) continue;
            String content = pt.getContent();
            count = count + content.split(find, -1).length - 1;
        }
        return count;
    }

    private Integer countMacroUsage(String macroKey) {
        ConfluenceUser admin = this.confluenceUtilities_m.getUser(this.confluenceUtilities_m.getAdminUser());
        AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
        SearchContext context = SearchContext.builder().contentStatus(List.of(ContentStatus.CURRENT)).build();
        Integer count = this.cqlSearchService_m.countContent("siteSearch ~ \"macroName:" + macroKey + "\"", context);
        AuthenticatedUserThreadLocal.reset();
        return count + this.countMacroUsageInTemplates(macroKey);
    }

    public void sendMacroUsage(String macroKey, @Nullable Long count) {
        if (this.confluenceDCChecker_m.hasCurrentNodeLowestId()) {
            Long usageCount = (long)this.countMacroUsage(macroKey);
            if (count != null) {
                usageCount = usageCount + count;
            }
            if (usageCount > 0L) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("count", String.valueOf(usageCount));
                properties.put("sen", this.SEN_m);
                properties.put("client_id", this.clientId_m);
                properties.put("plugin_name", this.pluginName_m);
                String eventName = macroKey.replaceAll("[^\\d\\w]", "_");
                this.analytics_m.enqueue((MessageBuilder)((TrackMessage.Builder)TrackMessage.builder((String)eventName).userId(this.clientId_m)).properties(properties));
            }
        }
    }

    public void sendEventMetrics(String eventName, Long count) {
        if (this.confluenceDCChecker_m.hasCurrentNodeLowestId() && count > 0L) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("count", String.valueOf(count));
            properties.put("sen", this.SEN_m);
            properties.put("client_id", this.clientId_m);
            properties.put("plugin_name", this.pluginName_m);
            eventName = eventName.replaceAll("[^\\d\\w]", "_");
            this.analytics_m.enqueue((MessageBuilder)((TrackMessage.Builder)TrackMessage.builder((String)eventName).userId(this.clientId_m)).properties(properties));
        }
    }
}

