AJS.toInit(function ()
{
    // ... your initialisation code here

    // We want to render the Dialogs from Soy templates on the page so we can show() it when needed
    AJS.$("#main").after(EasyForums.Templates.Soy.statusDialogForm());

    var pageId;
    var element;

    AJS.$('.setstatus').click(function()
    {
        pageId = $(this).data("easyForumsPageid");
        element = $(this);
        AJS.$("#dialog-apply-button").prop('disabled', true);
        AJS.dialog2("#easy-forums-status-dialog").show();
    });

    $(document).on('click', '.setwatches', function()
    {
        var currentValue = $(this).html();
        var CurrentEl = $(this);

        $.post(AJS.params.contextPath + "/plugins/servlet/easyforums/setWatchesServlet",
        {
            pageId:     $(this).data("easyForumsPageid"),
            userKey:    $(this).data("easyForumsUserid"),
            action:     currentValue,
            atl_token:  AJS.Meta.get("atl-token")
        }).success(function(data, status) {
            CurrentEl.parent().replaceWith(data);
        }).error(function(jqXHR) {
            handleError(jqXHR.status, jqXHR.responseText);
        });
        return false;
    });

    // Hides the dialog
    AJS.$("#dialog-close-button").click(function(e)
    {
        e.preventDefault();
        // clear selection
        AJS.$("#ef-select-status-type").select2("val", "");
        AJS.dialog2("#easy-forums-status-dialog").hide();
    });

    // Handle Apply click
    AJS.$("#dialog-apply-button").click(function(e)
    {
        // get text from dropdown
        $.post(AJS.params.contextPath + "/plugins/servlet/easyforums/setStatusServlet",
        {
            pageId:     pageId,
            action:     AJS.$("#ef-select-status-type").val(),
            atl_token:  AJS.Meta.get("atl-token")
        }).success(function(data, status) {
            element.html(data);
        }).error(function(jqXHR) {
            handleError(jqXHR.status, jqXHR.responseText);
        });
        e.preventDefault();
        // clear selection
        AJS.$("#ef-select-status-type").select2("val", "");
        AJS.dialog2("#easy-forums-status-dialog").hide();
    });

    AJS.$(".ef-hiddencontent-checkbox").click(function(e)
    {
        e.preventDefault();
        $.post(AJS.params.contextPath + "/plugins/servlet/easyforums/setStatusServlet",
        {
            'action'  : "ToggleHidden",
            'value'   : $(this).is(':checked'),
            'userKey' : $(this).attr("userkey"),
            atl_token:  AJS.Meta.get("atl-token")
        }).success(function(data, statusText, xhr) {
            if(xhr.status == 200)
            {
                location.reload();
            }
        }).error(function(jqXHR) {
            handleError(jqXHR.status, jqXHR.responseText);
        });
    });

    AJS.$('#ef-select-status-type').auiSelect2(
    {
        ajax: {
            url: AJS.params.contextPath + "/plugins/servlet/easyforums/setStatusServlet",
            dataType: 'json',
            contentType: 'application/json',
            type: 'GET',
            quietMillis: 0,
            data: function (params)
            {
                // no params
                return {}
            },
            results: function (data)
            {
                console.log(data);
                // data = {"results":[{"id":"-1","text":"Active"},{"id":"-2","text": "Read Only"},{"id:-3","text": "Hidden"}, "blah", "blah"]}
                // parse the results into the format expected by Select2
                var results = [];
                $.each(data.results, function(index, item){
                    console.log("item: " + item);
                    results.push({id: item.id, text:item.text, selected:item.selected});
                });
                return {
                  results: results
                };
            }
        },
        placeholder: "Select New Status",
        dropdownCssClass : 'ef-select-status-width',
        allowClear: true,
        minimumResultsForSearch: Infinity
        //formatSearching: function() { return "Start typing user name..."; }
    }).on("select2-close", function () {
        setTimeout(function() {
            $('.select2-container-active').removeClass('select2-container-active');
            $(':focus').blur();
        }, 1);
    });

     $(document).on('change', '#ef-select-status-type', function(e)
     {
        AJS.$("#dialog-apply-button").prop('disabled', false);
     });

});
