/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.servlets;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.ForumConstants;
import net.kentcom.easyforums.StatusType;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetStatusServlet
extends HttpServlet {
    private final BandanaManager bandanaManager_m;
    private final StatusType statusType_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(SetStatusServlet.class);

    @Inject
    public SetStatusServlet(@ComponentImport BandanaManager bandanaManager, ConfluenceUtilities confluenceUtilities, StatusType statusType) {
        this.bandanaManager_m = bandanaManager;
        this.statusType_m = statusType;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(503);
            return;
        }
        String pageId = request.getParameter("pageId");
        String userKey = request.getParameter("userKey");
        String value = request.getParameter("value");
        String action = request.getParameter("action");
        if (action.equals("ToggleHidden")) {
            this.logger_m.info("pageId: " + pageId + " Action: " + action + " useyKey: " + userKey + " value: " + value);
            this.bandanaManager_m.setValue(ForumConstants.m_showHiddenContext, userKey, (Object)value);
        } else {
            Integer statusId = Integer.parseInt(action);
            this.logger_m.info("pageId: " + pageId + " Action: " + action + " useyKey: " + userKey + " value: " + value + " statusId " + statusId);
            this.bandanaManager_m.setValue(ForumConstants.m_statusContext, pageId, (Object)statusId);
            action = this.statusType_m.getValue(statusId);
        }
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().write(action);
        response.setStatus(200);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject json = new JSONObject();
        JSONArray statusList = new JSONArray();
        Set<Map.Entry<Integer, String>> statusEntries = this.statusType_m.getValues();
        for (Map.Entry<Integer, String> entry : statusEntries) {
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)entry.getKey());
            obj.put("text", (Object)entry.getValue());
            statusList.put((Object)obj);
        }
        json.put("results", (Object)statusList);
        response.setContentType("application/json; charset=UTF-8");
        response.getWriter().write(json.toString());
        response.setStatus(200);
    }
}

