/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums.servlets;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchAdminPageServlet
extends HttpServlet {
    private final UserManager userManager_m;
    private final LoginUriProvider loginUriProvider_m;
    private final TemplateRenderer templateRenderer_m;
    private final Logger logger_m = LoggerFactory.getLogger(LaunchAdminPageServlet.class);

    @Inject
    public LaunchAdminPageServlet(@ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer) {
        this.userManager_m = userManager;
        this.loginUriProvider_m = loginUriProvider;
        this.templateRenderer_m = templateRenderer;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.logger_m.info("goGet");
        UserProfile user = this.userManager_m.getRemoteUser(request);
        if (user == null || !this.userManager_m.isSystemAdmin(user.getUserKey())) {
            this.redirectToLogin(request, response);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer_m.render("templates/easy-forums/admin.vm", (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider_m.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

