/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedType {
    protected final BandanaManager bandanaManager_m;
    protected final BandanaContext bandanaContext_m;
    protected Integer lastID_m = 0;
    public Map<Integer, String> typeValues_m = new HashMap<Integer, String>();
    private final Logger logger_m = LoggerFactory.getLogger(IndexedType.class);

    public IndexedType(BandanaManager bandanaManager) {
        this.bandanaManager_m = bandanaManager;
        this.bandanaContext_m = new ConfluenceBandanaContext("EF-" + this.getClass().getSimpleName());
        this.logger_m.info("Bandana Context: EF-" + this.getClass().getSimpleName());
        this.LoadValues();
    }

    private void LoadValues() {
        for (String key : this.bandanaManager_m.getKeys(this.bandanaContext_m)) {
            Integer ID = Integer.parseInt(key);
            this.typeValues_m.put(ID, (String)this.bandanaManager_m.getValue(this.bandanaContext_m, key));
            this.lastID_m = Math.max(ID, this.lastID_m);
        }
    }

    protected boolean addSystemValue(Integer id, String newValue) {
        if (this.typeValues_m.containsValue(newValue)) {
            return false;
        }
        if (id > 0) {
            return false;
        }
        this.typeValues_m.put(id, newValue);
        return true;
    }

    public Integer addValue(String newValue) {
        if (this.typeValues_m.containsValue(newValue) || newValue.equals("null")) {
            return 0;
        }
        Integer n = this.lastID_m;
        Integer n2 = this.lastID_m = Integer.valueOf(this.lastID_m + 1);
        this.typeValues_m.put(this.lastID_m, newValue);
        this.bandanaManager_m.setValue(this.bandanaContext_m, this.lastID_m.toString(), (Object)newValue);
        return this.lastID_m;
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean renameValue(String oldValue, String newValue) {
        Integer ID;
        if (this.typeValues_m.containsValue(oldValue) && (ID = IndexedType.getKeyByValue(this.typeValues_m, oldValue)) != null && ID > 0) {
            this.typeValues_m.remove(ID);
            this.typeValues_m.put(ID, newValue);
            this.bandanaManager_m.setValue(this.bandanaContext_m, ID.toString(), (Object)newValue);
            return true;
        }
        return false;
    }

    public boolean deleteValue(String value) {
        Integer ID;
        if (this.typeValues_m.containsValue(value) && (ID = IndexedType.getKeyByValue(this.typeValues_m, value)) != null && ID > 0) {
            this.typeValues_m.remove(ID);
            this.bandanaManager_m.removeValue(this.bandanaContext_m, ID.toString());
            return true;
        }
        return false;
    }

    public Set<Map.Entry<Integer, String>> getValues() {
        return this.typeValues_m.entrySet();
    }

    public Integer getID(String value) {
        Integer ID;
        if (this.typeValues_m.containsValue(value) && (ID = IndexedType.getKeyByValue(this.typeValues_m, value)) != null) {
            return ID;
        }
        return 0;
    }

    public String getValue(Integer ID) {
        if (this.typeValues_m.containsKey(ID)) {
            return this.typeValues_m.get(ID);
        }
        return null;
    }
}

