AJS.toInit(function ()
{
    // ... your initialisation code here
    AJS.$("#main").after(EasyForums.Templates.Soy.efMessageDiv());


    function renameComments()
    {
        var heading = $('#comments-section-title');
        if(heading.length > 0)
            heading.html(heading.html().replace("Comment", "Post"));

        $('.quick-comment-prompt span').each(function()
        {
            $(this).html($(this).html().replace("comment", "post"));
        });

        // keep checking, in case a new comment is added to the page (does not refresh)
        setTimeout(renameComments, 1000);
    }

    // may need to do this under a timer....
    renameComments();
});

AJS.bind("blueprint.wizard-register.ready", function ()
{
    function submitForumSpace(e, state) {
        state.pageData.ContentPageTitle = state.pageData.name + " Home Page";
        return Confluence.SpaceBlueprint.CommonWizardBindings.submit(e, state);
    }
    function preRenderForumSpace(e, state) {
        state.soyRenderContext['atlToken'] = AJS.Meta.get('atl-token');
        state.soyRenderContext['showSpacePermission'] = false;
    }
    Confluence.Blueprint.setWizard('net.kentcom.easy-forums:easy-forums-space-blueprint', function(wizard) {
        wizard.on("submit.easy-forums-spaceBasicDetailsId", submitForumSpace);
        wizard.on("pre-render.easy-forums-spaceBasicDetailsId", preRenderForumSpace);
        wizard.on("post-render.easy-forums-spaceBasicDetailsId", Confluence.SpaceBlueprint.CommonWizardBindings.postRender);
    });
});

function handleError(error, message)
{
    if(!message)
    {
        if (error == 503) {
            // DC read-only mode....
            message = "Confluence is in READ-ONLY mode, this action is not available";
        } else if (error == 401) {
            // unauthorised, we don't need to display a message here....
            return;
        } else if (error == 403) {  // forbidden
            // license error
            message = AJS.I18n.getText("net.kentcom.easy-forums.unlicensed");
        } else {
            // 400 bad request, should not happen
            message = "Internal Server error, contact Administrator and refer to logs";
        }
    }
    console.log(error);

    AJS.messages.warning("#efMessageDiv",
    {
       title: AJS.I18n.getText("net.kentcom.easy-forums.plugin.name"),
       body: message,
       closeable: true,
       fadeout: true,
       delay  : 5000
    });
}
