/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.user.User;
import java.util.List;
import net.kentcom.easyforums.EasyForumsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler
implements Runnable {
    private final PageViewEvent pageViewEvent_m;
    private final CommentCreateEvent commentCreateEvent_m;
    private final CommentUpdateEvent commentUpdateEvent_m;
    private final PageUpdateEvent pageUpdateEvent_m;
    private final BlueprintPageCreateEvent blueprintPageCreateEvent_m;
    private final NotificationManager notificationManager_m;
    private final LabelManager labelManager_m;
    private final BandanaManager bandanaManager_m;
    private final Logger logger_m = LoggerFactory.getLogger(EventHandler.class);

    public EventHandler(PageViewEvent event, BandanaManager bandanaManager) {
        this.pageViewEvent_m = event;
        this.bandanaManager_m = bandanaManager;
        this.commentCreateEvent_m = null;
        this.commentUpdateEvent_m = null;
        this.pageUpdateEvent_m = null;
        this.blueprintPageCreateEvent_m = null;
        this.notificationManager_m = null;
        this.labelManager_m = null;
    }

    public EventHandler(CommentCreateEvent event, BandanaManager bandanaManager) {
        this.commentCreateEvent_m = event;
        this.bandanaManager_m = bandanaManager;
        this.pageViewEvent_m = null;
        this.commentUpdateEvent_m = null;
        this.pageUpdateEvent_m = null;
        this.blueprintPageCreateEvent_m = null;
        this.notificationManager_m = null;
        this.labelManager_m = null;
    }

    public EventHandler(CommentUpdateEvent event, BandanaManager bandanaManager) {
        this.commentUpdateEvent_m = event;
        this.bandanaManager_m = bandanaManager;
        this.pageViewEvent_m = null;
        this.commentCreateEvent_m = null;
        this.pageUpdateEvent_m = null;
        this.blueprintPageCreateEvent_m = null;
        this.notificationManager_m = null;
        this.labelManager_m = null;
    }

    public EventHandler(PageUpdateEvent event, BandanaManager bandanaManager) {
        this.pageUpdateEvent_m = event;
        this.bandanaManager_m = bandanaManager;
        this.pageViewEvent_m = null;
        this.commentCreateEvent_m = null;
        this.commentUpdateEvent_m = null;
        this.blueprintPageCreateEvent_m = null;
        this.notificationManager_m = null;
        this.labelManager_m = null;
    }

    public EventHandler(BlueprintPageCreateEvent event, BandanaManager bandanaManager, NotificationManager notificationManager, LabelManager labelManager) {
        this.blueprintPageCreateEvent_m = event;
        this.bandanaManager_m = bandanaManager;
        this.notificationManager_m = notificationManager;
        this.labelManager_m = labelManager;
        this.pageViewEvent_m = null;
        this.commentCreateEvent_m = null;
        this.commentUpdateEvent_m = null;
        this.pageUpdateEvent_m = null;
    }

    @Override
    public void run() {
        if (this.pageViewEvent_m != null) {
            this.logger_m.info("pageViewEvent");
            Page page = this.pageViewEvent_m.getPage();
            Boolean isTopic = EasyForumsConstants.isPageTopic((Labelable)page);
            if (isTopic.booleanValue()) {
                this.incrementViewCount(page);
            }
        } else if (this.commentCreateEvent_m != null) {
            this.logger_m.info("commentCreateEvent");
            Comment comment = this.commentCreateEvent_m.getComment();
            ContentEntityObject page = comment.getContainer();
            if (EasyForumsConstants.isPageTopic((Labelable)page)) {
                this.storeLastUpdateTime(page, (ContentEntityObject)comment);
            }
        } else if (this.commentUpdateEvent_m != null) {
            this.logger_m.info("commentUpdateEvent");
            Comment comment = this.commentUpdateEvent_m.getComment();
            ContentEntityObject page = comment.getContainer();
            if (EasyForumsConstants.isPageTopic((Labelable)page)) {
                this.storeLastUpdateTime(page, (ContentEntityObject)comment);
            }
        } else if (this.pageUpdateEvent_m != null) {
            this.logger_m.info("pageUpdateEvent");
            Page page = this.pageUpdateEvent_m.getPage();
            Boolean isTopic = EasyForumsConstants.isPageTopic((Labelable)page);
            if (isTopic.booleanValue()) {
                this.storeLastUpdateTime((ContentEntityObject)page, (ContentEntityObject)page);
            }
        } else if (this.blueprintPageCreateEvent_m != null) {
            this.logger_m.info("blueprintPageCreateEvent");
            ModuleCompleteKey TOPIC_BLUEPRINT_KEY = new ModuleCompleteKey("net.kentcom.easy-forums", "easy-forums-topic-blueprint");
            ContentBlueprint contentBlueprint = this.blueprintPageCreateEvent_m.getBlueprint();
            String moduleCompleteKey = contentBlueprint.getModuleCompleteKey();
            Page page = this.blueprintPageCreateEvent_m.getPage();
            if (moduleCompleteKey.equals(TOPIC_BLUEPRINT_KEY.getCompleteKey())) {
                this.logger_m.info("Created a Topic from blueprint");
                this.storeLastUpdateTime((ContentEntityObject)page, (ContentEntityObject)page);
                List forumLabels = page.getParent().getLabels();
                for (Label label : forumLabels) {
                    if (label.equals((Object)EasyForumsConstants.m_forumLabel)) continue;
                    this.labelManager_m.addLabel((Labelable)page, label);
                }
                for (Notification notification : this.notificationManager_m.getNotificationsByContent((ContentEntityObject)page.getParent())) {
                    this.notificationManager_m.addContentNotification((User)notification.getReceiver(), (ContentEntityObject)page);
                }
            }
        }
    }

    private void incrementViewCount(Page page) {
        this.logger_m.info(page.toString());
        long count = 1L;
        String key = page.getIdAsString();
        try {
            count = (Long)this.bandanaManager_m.getValue(EasyForumsConstants.m_pageViewContext, key);
            this.logger_m.info("Current count: " + count);
            ++count;
        }
        catch (Exception e) {
            this.logger_m.error("Not in Bandana: " + e);
        }
        this.bandanaManager_m.setValue(EasyForumsConstants.m_pageViewContext, key, (Object)count);
    }

    private void storeLastUpdateTime(ContentEntityObject topic, ContentEntityObject update) {
        this.logger_m.info("Storing pageID: " + topic.getIdAsString() + " with: " + update.getId());
        this.bandanaManager_m.setValue(EasyForumsConstants.m_bandanaContext, topic.getIdAsString(), (Object)update.getId());
        this.bandanaManager_m.setValue(EasyForumsConstants.m_bandanaContext, ((Page)topic).getParent().getIdAsString(), (Object)update.getId());
    }
}

