/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.ConfUtilities;
import net.kentcom.easyforums.EasyForumsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetWatchesServlet
extends HttpServlet {
    private final NotificationManager notificationManager_m;
    private final UserAccessor userAccessor_m;
    private final PageManager pageManager_m;
    private final I18nResolver i18nResolver_m;
    private final ConfUtilities confUtilities_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private static final Logger logger_m = LoggerFactory.getLogger(SetWatchesServlet.class);

    @Inject
    public SetWatchesServlet(@ComponentImport NotificationManager notificationManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport I18nResolver i18nResolver, ConfluenceUtilities confluenceUtilities, ConfUtilities confUtilities) {
        this.notificationManager_m = notificationManager;
        this.userAccessor_m = userAccessor;
        this.pageManager_m = pageManager;
        this.i18nResolver_m = i18nResolver;
        this.confluenceUtilities_m = confluenceUtilities;
        this.confUtilities_m = confUtilities;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.confluenceUtilities_m.isConfluenceReadOnly()) {
            response.setStatus(503);
            return;
        }
        String pageId = request.getParameter("pageId");
        String userKey = request.getParameter("userKey");
        String action = request.getParameter("action");
        Page page = this.pageManager_m.getPage(Long.parseLong(pageId));
        UserKey key = new UserKey(userKey);
        ConfluenceUser user = this.userAccessor_m.getExistingUserByKey(key);
        Boolean forum = EasyForumsConstants.isPageForum((Labelable)page);
        String watching = this.i18nResolver_m.getText("net.kentcom.easy-forums.watching.yes");
        logger_m.info("pageId: " + pageId + " userKey: " + userKey + " Action: " + action);
        if (action.equals(watching)) {
            this.removeWatch(page, user, forum);
            logger_m.info("Removed Watch");
        } else {
            this.addWatch(page, user, forum);
            logger_m.info("Added Watch");
        }
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().write(this.confUtilities_m.getWatchLink(page, user));
        response.setStatus(200);
    }

    private void removeWatch(Page page, ConfluenceUser user, Boolean forum) {
        if (user != null) {
            this.notificationManager_m.removeContentNotification((User)user, (ContentEntityObject)page);
            if (forum.booleanValue()) {
                for (Page child : page.getChildren()) {
                    if (!EasyForumsConstants.isPageTopic((Labelable)child)) continue;
                    this.notificationManager_m.removeContentNotification((User)user, (ContentEntityObject)child);
                }
            }
        }
    }

    private void addWatch(Page page, ConfluenceUser user, Boolean forum) {
        if (user != null) {
            this.notificationManager_m.addContentNotification((User)user, (ContentEntityObject)page);
            if (forum.booleanValue()) {
                for (Page child : page.getChildren()) {
                    if (!EasyForumsConstants.isPageTopic((Labelable)child)) continue;
                    this.notificationManager_m.addContentNotification((User)user, (ContentEntityObject)child);
                }
            }
        }
    }
}

