/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.easyforums.EasyForumsConstants;
import net.kentcom.easyforums.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class ForumListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher_m;
    private final BandanaManager bandanaManager_m;
    private final NotificationManager notificationManager_m;
    private final AppConfigSettings appConfigSetting_m;
    private final LicenseCheck licenseCheck_m;
    private final LabelManager labelManager_m;
    private final UserAccessor userAccessor_m;
    private final I18nResolver i18nResolver_m;
    private final ExecutorService executorService_m;
    private final Logger logger_m = LoggerFactory.getLogger(ForumListener.class);
    private SummaryMap summaryHeadings_m = null;
    private ForumMap forumHeadings_m = null;

    public SummaryMap getSummaryMap() {
        if (this.summaryHeadings_m == null) {
            this.summaryHeadings_m = this.createSummaryMap();
        }
        return this.summaryHeadings_m;
    }

    public ForumMap getForumMap() {
        if (this.forumHeadings_m == null) {
            this.forumHeadings_m = this.createForumMap();
        }
        return this.forumHeadings_m;
    }

    @Inject
    public ForumListener(@ComponentImport EventPublisher eventPublisher, @ComponentImport BandanaManager bandanaManager, @ComponentImport UserAccessor userAccessor, @ComponentImport NotificationManager notificationManager, @ComponentImport LabelManager labelManager, @ComponentImport I18nResolver i18nResolver, LicenseCheck licenseCheck, AppConfigSettings appConfigSetting) {
        this.i18nResolver_m = i18nResolver;
        this.eventPublisher_m = eventPublisher;
        this.bandanaManager_m = bandanaManager;
        this.notificationManager_m = notificationManager;
        this.labelManager_m = labelManager;
        this.userAccessor_m = userAccessor;
        this.licenseCheck_m = licenseCheck;
        this.appConfigSetting_m = appConfigSetting;
        this.executorService_m = Executors.newFixedThreadPool(50);
    }

    public void afterPropertiesSet() throws Exception {
        this.logger_m.info("afterPropertiesSet");
        ConfluenceUtilities.enableLogging();
        this.eventPublisher_m.register((Object)this);
    }

    @PluginEventListener
    public void pluginEnabledEvent(PluginEnabledEvent event) {
        if (this.userAccessor_m.getGroup(EasyForumsConstants.m_moderatorGroupName) == null) {
            try {
                this.userAccessor_m.createGroup(EasyForumsConstants.m_moderatorGroupName);
            }
            catch (Exception e) {
                this.logger_m.error("Unable to create Confluence Group \"" + EasyForumsConstants.m_moderatorGroupName + "\" please create this Confluence Group Manually");
            }
        }
        this.logger_m.error("License Valid: {}", (Object)this.licenseCheck_m.isLicenseOK("net.kentcom.easy-forums"));
        this.appConfigSetting_m.initialise(EasyForumsConstants.m_bandanaContextStr, "net.kentcom.easy-forums", "Easy Forums");
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_pluginVersion, this.licenseCheck_m.getPluginVersion());
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_showAvatar, Boolean.TRUE);
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_renderTablesOnly, Boolean.FALSE);
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_forumTemplate, "EasyForums-Forum");
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_maxTableItems, 100);
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_defaultSortColumn, EasyForumsConstants.SummaryColumns.LAST_POST.name());
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_showLabels, Boolean.FALSE);
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_showSidebar, Boolean.FALSE);
        this.appConfigSetting_m.addSetting(EasyForumsConstants.m_maxForumModerators, 3);
        this.getSummaryMap();
        this.getForumMap();
        Label label = this.labelManager_m.getLabel(EasyForumsConstants.m_forumLabelStr);
        EasyForumsConstants.m_forumLabel = label == null ? this.labelManager_m.createLabel(new Label(EasyForumsConstants.m_forumLabelStr)) : label;
        label = this.labelManager_m.getLabel(EasyForumsConstants.m_topicLabelStr);
        EasyForumsConstants.m_topicLabel = label == null ? this.labelManager_m.createLabel(new Label(EasyForumsConstants.m_topicLabelStr)) : label;
    }

    public void destroy() throws Exception {
        this.eventPublisher_m.unregister((Object)this);
        this.executorService_m.shutdown();
    }

    @EventListener
    public void onPageViewEvent(PageViewEvent event) {
        EventHandler handler = new EventHandler(event, this.bandanaManager_m);
        this.executorService_m.execute(handler);
    }

    @EventListener
    public void commentCreateEvent(CommentCreateEvent event) {
        this.logger_m.info("commentCreateEvent");
        EventHandler handler = new EventHandler(event, this.bandanaManager_m);
        this.executorService_m.execute(handler);
    }

    @EventListener
    public void commentUpdateEvent(CommentUpdateEvent event) {
        EventHandler handler = new EventHandler(event, this.bandanaManager_m);
        this.executorService_m.execute(handler);
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        EventHandler handler = new EventHandler(event, this.bandanaManager_m);
        this.executorService_m.execute(handler);
    }

    @EventListener
    public void onBlueprintCreateEvent(BlueprintPageCreateEvent event) {
        this.logger_m.info("onBlueprintCreateEvent");
        EventHandler handler = new EventHandler(event, this.bandanaManager_m, this.notificationManager_m, this.labelManager_m);
        this.executorService_m.execute(handler);
    }

    private SummaryMap createSummaryMap() {
        SummaryMap myMap = new SummaryMap();
        for (EasyForumsConstants.SummaryColumns col : EasyForumsConstants.SummaryColumns.values()) {
            String colName = col.name();
            this.appConfigSetting_m.addSetting("EF-Summary-" + colName, true);
            myMap.put(col, new ColumnAttributes(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.column." + colName), (Boolean)this.appConfigSetting_m.getSetting("EF-Summary-" + colName)));
        }
        return myMap;
    }

    private ForumMap createForumMap() {
        ForumMap myMap = new ForumMap();
        for (EasyForumsConstants.ForumColumns col : EasyForumsConstants.ForumColumns.values()) {
            String colName = col.name();
            this.appConfigSetting_m.addSetting("EF-Forum-" + colName, true);
            myMap.put(col, new ColumnAttributes(this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.column." + colName), (Boolean)this.appConfigSetting_m.getSetting("EF-Forum-" + colName)));
        }
        return myMap;
    }

    public void updateForumMap(EasyForumsConstants.ForumColumns column, Boolean visible) {
        ForumMap forumMap = this.getForumMap();
        ColumnAttributes attr = (ColumnAttributes)forumMap.get((Object)column);
        attr.setVisible(visible);
        forumMap.put(column, attr);
        this.appConfigSetting_m.setSetting("EF-Forum-" + column.name(), visible);
    }

    public void updateSummaryMap(EasyForumsConstants.SummaryColumns column, Boolean visible) {
        SummaryMap summaryMap = this.getSummaryMap();
        ColumnAttributes attr = (ColumnAttributes)summaryMap.get((Object)column);
        attr.setVisible(visible);
        summaryMap.put(column, attr);
        this.appConfigSetting_m.setSetting("EF-Summary-" + column.name(), visible);
    }

    public class ForumMap
    extends HashMap<EasyForumsConstants.ForumColumns, ColumnAttributes> {
    }

    public class SummaryMap
    extends HashMap<EasyForumsConstants.SummaryColumns, ColumnAttributes> {
    }

    public class ColumnAttributes {
        private String Name_m;
        private Boolean Visible_m;

        ColumnAttributes(String Name, Boolean Visible) {
            this.Name_m = Name;
            this.Visible_m = Visible;
        }

        public String Name() {
            return this.Name_m;
        }

        public Boolean isVisible() {
            return this.Visible_m;
        }

        public void setVisible(Boolean visible) {
            this.Visible_m = visible;
        }
    }
}

