/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.easyforums.EasyForumsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ConfUtilities {
    private final UserAccessor userAccessor_m;
    private final AppConfigSettings appConfigSetting_m;
    private final BandanaManager bandanaManager_m;
    private final NotificationManager notificationManager_m;
    private final I18nResolver i18nResolver_m;
    private final XhtmlContent xhtmlContent_m;
    private final PageTemplateManager pageTemplateManager_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final Logger logger_m = LoggerFactory.getLogger(ConfUtilities.class);

    @Inject
    public ConfUtilities(@ComponentImport UserAccessor userAccessor, @ComponentImport BandanaManager bandanaManager, @ComponentImport NotificationManager notificationManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport PageTemplateManager pageTemplateManager, AppConfigSettings appConfigSetting, ConfluenceUtilities confluenceUtilities) {
        this.userAccessor_m = userAccessor;
        this.bandanaManager_m = bandanaManager;
        this.notificationManager_m = notificationManager;
        this.i18nResolver_m = i18nResolver;
        this.xhtmlContent_m = xhtmlContent;
        this.pageTemplateManager_m = pageTemplateManager;
        this.appConfigSetting_m = appConfigSetting;
        this.confluenceUtilities_m = confluenceUtilities;
    }

    public String getNumWatchesBadge(ContentEntityObject ceo) {
        List allWatches = this.notificationManager_m.getNotificationsByContent(ceo);
        return "<span class=\"ef-badge\" style=\"vertical-align: unset;\">" + allWatches.size() + "</span>";
    }

    public String getWatchLink(Page page, ConfluenceUser user) {
        try {
            String isWatching = this.notificationManager_m.isWatchingContent((User)user, (ContentEntityObject)page) ? this.i18nResolver_m.getText("net.kentcom.easy-forums.watching.yes") : this.i18nResolver_m.getText("net.kentcom.easy-forums.watching.no");
            return "<div>" + this.getNumWatchesBadge((ContentEntityObject)page) + " <a class=\"setwatches\" data-easy-forums-pageid=\"" + page.getIdAsString() + "\" data-easy-forums-userid=\"" + user.getKey() + "\" href=\"#\">" + isWatching + "</a></div>";
        }
        catch (Exception e) {
            return this.i18nResolver_m.getText("net.kentcom.easy-forums.watching.anonymous");
        }
    }

    public boolean isUserModerator(ConfluenceUser user, String pageId) {
        try {
            ConfluenceBandanaContext modContext = new ConfluenceBandanaContext(EasyForumsConstants.m_moderatorContentPrefix + pageId);
            this.checkMaxModerators((BandanaContext)modContext);
            String forumModerator = (String)this.bandanaManager_m.getValue((BandanaContext)modContext, user.getKey().getStringValue());
            return this.confluenceUtilities_m.isUserInGroup(user, EasyForumsConstants.m_moderatorGroupName) || forumModerator != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String renderSearchBox(String searchPrompt, ConversionContext conversionContext) {
        String text = "<div class=\"columnLayout two-equal\" data-layout=\"two-equal\">  <div class=\"cell normal\" data-type=\"normal\">    <div class=\"innerCell ef-no-scrollbars\">      <h1  class=\"ef-text-right\">" + searchPrompt + "      </h1>    </div>  </div>  <div class=\"cell normal\" data-type=\"normal\">    <div class=\"innerCell\">      <ac:structured-macro ac:name=\"pagetreesearch\" ac:schema-version=\"1\" />    </div>  </div></div>";
        try {
            return this.xhtmlContent_m.convertStorageToView(text, conversionContext);
        }
        catch (Exception e) {
            this.logger_m.error(ConfluenceUtilities.getStackTrace(e));
            return "ERROR: " + e.toString();
        }
    }

    public String hidePageElements(boolean hideEditButton, boolean hideComments, boolean readOnlyComments, boolean hideLabels, boolean hideActionMenu, boolean hidePageMetadata) {
        boolean showSidebar;
        StringBuilder builder = new StringBuilder();
        try {
            showSidebar = (Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showSidebar);
        }
        catch (Exception e) {
            showSidebar = Boolean.parseBoolean((String)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showSidebar));
        }
        builder.append("<style type=\"text/css\">");
        if (!showSidebar) {
            builder.append("div.vsplitbar, #splitter-sidebar, #ia-splitter-left, .ia-splitter-left {display: none !important;}");
            builder.append("#splitter-content {left: 0 !important; width: 100% !important;} #main { margin-left: 0 !important; max-width: none !important; width: 100% !important}");
        }
        if (hideEditButton) {
            builder.append("#editPageLink, ");
        }
        if (hideActionMenu) {
            builder.append("#action-menu-link, ");
        }
        if (hideComments) {
            builder.append("#comments-section, ");
        }
        if (readOnlyComments) {
            builder.append(".quick-comment-container, .action-reply-comment, .comment-action-edit, .comment-action-remove, ");
        }
        if (hidePageMetadata) {
            builder.append("div.page-metadata > ul, #page-metadata-banner, .content-meta-outer > .content-meta, ");
        }
        builder.append("#breadcrumbs .first, ");
        if (hideLabels) {
            builder.append("#labels-section, ");
        }
        builder.append("#view-in-hierarchy-link, #quick-create-page-button, #create-page-button, #children-section, #likes-section {display:none !important;}");
        builder.append("</style>");
        return builder.toString();
    }

    public String renderForumModerators(String pageId) {
        ConfluenceBandanaContext modContext = new ConfluenceBandanaContext(EasyForumsConstants.m_moderatorContentPrefix + pageId);
        List userKeys = (List)this.bandanaManager_m.getKeys((BandanaContext)modContext);
        int max = (Integer)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_maxForumModerators);
        String template = "<span class=\"aui-label aui-label-closeable\" key=\"@key\">@name\n<span tabindex=\"0\" title=\"" + this.i18nResolver_m.getText("net.kentcom.easy-forums.delete") + "\" class=\"aui-icon aui-icon-close ef-remove-moderator\" key=\"@key\" ></span>\n</span>";
        StringBuilder builder = new StringBuilder();
        for (String userKey : userKeys) {
            ConfluenceUser user = this.userAccessor_m.getUserByKey(new UserKey(userKey));
            String html = template.replaceAll("@key", userKey);
            html = html.replaceAll("@name", user.getFullName());
            builder.append(html);
        }
        if (userKeys.size() >= max) {
            builder.append("<i>");
            builder.append(this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.max.configured"));
            builder.append("</i>");
        }
        return builder.toString();
    }

    private void checkMaxModerators(BandanaContext modContext) {
        List userKeys = (List)this.bandanaManager_m.getKeys(modContext);
        int max = (Integer)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_maxForumModerators);
        if (userKeys.size() > max) {
            int numToRemove = userKeys.size() - max;
            int numRemoved = 0;
            for (String userKey : userKeys) {
                this.bandanaManager_m.removeValue(modContext, userKey);
                if (++numRemoved < numToRemove) continue;
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String addCreateNewButton(String buttonName, String templateName, ConversionContext conversionContext, boolean forForum) {
        StringBuilder test = new StringBuilder();
        String customTemplate = (String)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_forumTemplate);
        test.append("<ac:structured-macro ac:name=\"create-from-template\">\n");
        test.append("<ac:parameter ac:name=\"buttonLabel\">");
        test.append(buttonName);
        test.append("</ac:parameter>\n");
        test.append("<ac:parameter ac:name=\"spaceKey\">");
        test.append("<ri:space ri:space-key=\"");
        test.append(conversionContext.getSpaceKey());
        test.append("\"/></ac:parameter>\n");
        if (forForum && !customTemplate.equals("EasyForums-Forum")) {
            PageTemplate pageTemplate = this.pageTemplateManager_m.getGlobalPageTemplate(customTemplate);
            if (pageTemplate == null) return "ERROR: Global template " + customTemplate + " not found";
            test.append("<ac:parameter ac:name=\"templateName\">");
            test.append(customTemplate);
            test.append("</ac:parameter>\n");
            test.append("<ac:parameter ac:name=\"templateId\">");
            test.append(pageTemplate.getId());
            test.append("</ac:parameter>\n");
        } else {
            test.append("<ac:parameter ac:name=\"blueprintModuleCompleteKey\">net.kentcom.easy-forums:");
            test.append(templateName);
            test.append("</ac:parameter>\n");
            test.append("<ac:parameter ac:name=\"templateName\">net.kentcom.easy-forums:");
            test.append(templateName);
            test.append("</ac:parameter>\n");
        }
        test.append("</ac:structured-macro>\n");
        this.logger_m.info(test.toString());
        try {
            return this.xhtmlContent_m.convertStorageToView(test.toString(), conversionContext);
        }
        catch (Exception e) {
            this.logger_m.error(e.toString());
            return "ERROR: " + e.toString();
        }
    }
}

