AJS.toInit(function () {
    // ... your initialisation code here

    function renameComments()
    {
        var heading = $('#comments-section-title');
        if(heading.length > 0)
            heading.html(heading.html().replace("Comment", "Post"));

        $('.quick-comment-prompt span').each(function()
        {
            $(this).html($(this).html().replace("comment", "post"));
        });

        // keep checking, in case a new comment is added to the page (does not refresh)
        setTimeout(renameComments, 1000);
    }

    // may need to do this under a timer....
    renameComments();
});

AJS.bind("blueprint.wizard-register.ready", function () {
    function submitForumSpace(e, state) {
        state.pageData.ContentPageTitle = state.pageData.name + " Home Page";
        return Confluence.SpaceBlueprint.CommonWizardBindings.submit(e, state);
    }
    function preRenderForumSpace(e, state) {
        state.soyRenderContext['atlToken'] = AJS.Meta.get('atl-token');
        state.soyRenderContext['showSpacePermission'] = false;
    }
    Confluence.Blueprint.setWizard('net.kentcom.easy-forums:easy-forums-space-blueprint', function(wizard) {
        wizard.on("submit.easy-forums-spaceBasicDetailsId", submitForumSpace);
        wizard.on("pre-render.easy-forums-spaceBasicDetailsId", preRenderForumSpace);
        wizard.on("post-render.easy-forums-spaceBasicDetailsId", Confluence.SpaceBlueprint.CommonWizardBindings.postRender);
    });
});

