(function ($) {
    // this closure helps us keep our variables to ourselves.
    // This pattern is known as an "iife" - immediately invoked function expression
  
    // wait for the DOM (i.e., document "skeleton") to load. This likely isn't necessary for the current case,
    // but may be helpful for AJAX that provides secondary content.
    $(document).ready(function()
    {
        // We want to render the Dialogs from Soy templates on the page so we can show() it when needed
        AJS.$("#main").after(EasyForums.Templates.Soy.statusDeleteVerify());

        // form the URL
        var url = AJS.params.contextPath + "/plugins/servlet/easyforums/configuration";

        // request the config information from the server
        $.ajax({
            url: url,
            type: "GET",
            data:
            {
                grab: "configuration"
            },
            dataType: "json",
        }).done(function(config) { // when the configuration is returned...
            // ...populate the form.
            $("#easyforums-showAvatar").prop("checked", config.showAvatar);
            $("#easyforums-renderTablesOnly").prop("checked", config.renderTablesOnly);
            $("#easyforums-showTopContributors").prop("checked", config.showTopContributors);
            $("#easyforums-maxTableItems").val(config.maxTableItems);
            $("#easyforums-showPageViews").prop("checked", config.showPageViews);
            $("#easyforums-defaultSortColumn").val(config.defaultSortColumn);
            $("#easyforums-showLabels").prop("checked", config.showLabels);
            $("#easyforums-showSidebar").prop("checked", config.showSidebar);
            $("#easyforums-maxForumModerators").val(config.maxForumModerators);

            $.each(config.templates, function (i, option) {
                $("#easyforums-forumTemplate").append('<option>'+option+'</option>');
            });
            $("#easyforums-forumTemplate").val(config.forumTemplate);
        });

        // request User status list
        console.log("Getting User Status");
        $.ajax({
            url: url,
            type: "GET",
            data:
            {
                grab: "user_status"
            },
            dataType: "html",
        }).done(function(text) { // when the configuration is returned...
            // ...populate the table
            document.getElementById("easyforums-user-status-fields").innerHTML = text;
        });

        function updateConfig() {
            $.ajax({
                url: url,
                type: "POST",
                data:
                {
                    store:              "configuration",
                    showAvatar:         AJS.$("#easyforums-showAvatar").is(':checked'),
                    renderTablesOnly:   AJS.$("#easyforums-renderTablesOnly").is(':checked'),
                    forumTemplate:      AJS.$("#easyforums-forumTemplate").val(),
                    showTopContributors:AJS.$("#easyforums-showTopContributors").is(':checked'),
                    maxTableItems:      AJS.$("#easyforums-maxTableItems").val(),
                    showPageViews:      AJS.$("#easyforums-showPageViews").is(':checked'),
                    defaultSortColumn:  AJS.$("#easyforums-defaultSortColumn").val(),
                    showLabels:         AJS.$("#easyforums-showLabels").is(':checked'),
                    showSidebar:        AJS.$("#easyforums-showSidebar").is(':checked'),
                    maxForumModerators: AJS.$("#easyforums-maxForumModerators").val()
                }
             }).done(function() {
                $("#easyforums-success").show();
             });
        }

        AJS.$("#easyforums-admin").submit(function(e) {
            e.preventDefault();
            updateConfig();
        });

        function hideSuccess()
        {
            $("#easyforums-success").hide();
        };

        AJS.$(".easyforums-input").change(function(e) {
            hideSuccess();
        });

        AJS.$("#easyforums-setup-moderators").click(function(e) {
            e.preventDefault();
            window.location.href = AJS.params.contextPath + "/admin/users/domembersofgroupsearch.action?membersOfGroupTerm=easyforums-moderators";
        });

        function modifyUserStatus(oldValue, newValue) {
        console.log(oldValue + " " + newValue);
            $.ajax({
                url: url,
                type: "POST",
                data:
                {
                    store:    "user_status",
                    action:   "modify",
                    oldValue:  oldValue,
                    newValue:  newValue
                }
             }).done(function(html) {
             console.log(html);
                if(html.length > 0)
                {
                    // it was deleted, replace table
                    document.getElementById("easyforums-user-status-fields").innerHTML = html;
                }
             });
        }

        var deleteValue;
        function deleteUserStatus() {
            $.ajax({
                url: url,
                type: "POST",
                data:
                {
                    store:    "user_status",
                    action:   "delete",
                    value:    deleteValue
                }
             }).done(function(html) {
                if(html.length > 0)
                {
                    // it was deleted, replace table
                    document.getElementById("easyforums-user-status-fields").innerHTML = html;
                }
             });
        }

        function addUserStatus(value) {
            $.ajax({
                url: url,
                type: "POST",
                data:
                {
                    store:    "user_status",
                    action:   "add",
                    value:    AJS.$('#ef-admin-field-addnew').val()
                }
             }).done(function(html) {
                if(html.length > 0)
                {
                    // it was added, replace table
                    document.getElementById("easyforums-user-status-fields").innerHTML = html;
                }
             });
        }

        // handle add new entry
        $(document).on('change keyup input paste', '#ef-admin-field-addnew', function(e)
        {
            AJS.$("#ef-admin-add-status").prop('disabled', false);
        });

        // handle Add button click
        $(document).on('click', '#ef-admin-add-status', function(e)
        {
            e.preventDefault();
            addUserStatus();
        });


        // handle Delete button click
        $(document).on('click', '.ef-admin-delete-status', function(e)
        {
            e.preventDefault();
            deleteValue = $(this).attr('value');
            // Show Delete warning dialog
            AJS.dialog2("#easy-forums-status-delete").show();
        });
        $(document).on('click', '#delete-verify-delete', function(e)
        {
            e.preventDefault();
            AJS.dialog2("#easy-forums-status-delete").hide();
            deleteUserStatus();
        });
        $(document).on('click', '#delete-verify-close', function(e)
         {
             e.preventDefault();
             AJS.dialog2("#easy-forums-status-delete").hide();
         });

        // handle Modify button click
        $(document).on('change keyup input paste', '.ef-admin-field-value', function(e)
        {
            AJS.$("#" + $(this).attr('buttonid')).prop('disabled', false);
        });
        $(document).on('click', '.ef-admin-modify-button', function(e)
        {
            e.preventDefault();
            var newValue = AJS.$("#" + $(this).attr('elementid')).val();
            modifyUserStatus($(this).attr('value'),newValue);
        });

    });

})(AJS.$ || jQuery);
