/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.LicenseCheck;
import net.kentcom.easyforums.ConfUtilities;
import net.kentcom.easyforums.EasyForumsConstants;
import net.kentcom.easyforums.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicMacro
implements Macro {
    private final LikeManager likeManager_m;
    private final AppConfigSettings appConfigSetting_m;
    private final XhtmlContent xhtmlContent_m;
    private final PermissionManager permissionManager_m;
    private final I18nResolver i18nResolver_m;
    private final ConfUtilities confUtilities_m;
    private final LicenseCheck licenseCheck_m;
    private final StatusType statusType_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final PageBuilderService pageBuilderService_m;
    private final Logger logger_m = LoggerFactory.getLogger(TopicMacro.class);

    @Inject
    public TopicMacro(@ComponentImport LikeManager likeManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport PermissionManager permissionManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport PageBuilderService pageBuilderService, AppConfigSettings appConfigSetting, ConfUtilities confUtilities, LicenseCheck licenseCheck, StatusType statusType, ConfluenceUtilities confluenceUtilities) {
        this.likeManager_m = likeManager;
        this.xhtmlContent_m = xhtmlContent;
        this.permissionManager_m = permissionManager;
        this.i18nResolver_m = i18nResolver;
        this.appConfigSetting_m = appConfigSetting;
        this.confUtilities_m = confUtilities;
        this.licenseCheck_m = licenseCheck;
        this.statusType_m = statusType;
        this.confluenceUtilities_m = confluenceUtilities;
        this.pageBuilderService_m = pageBuilderService;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        boolean showLabels;
        this.pageBuilderService_m.assembler().resources().requireWebResource("net.kentcom.easy-forums:easy-forums-resources");
        this.statusType_m.initialise();
        Integer myId = (Integer)conversionContext.getProperty("EasyForums-TopicMacro", (Object)1);
        if (myId > 1) {
            return "<div><b><em>" + this.i18nResolver_m.getText("net.kentcom.easy-forums.topic.duperror") + "</em></b></div>";
        }
        conversionContext.setProperty("EasyForums-TopicMacro", (Object)(myId + 1));
        StringBuilder builder = new StringBuilder();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Page page = (Page)conversionContext.getEntity();
        Page parent = page.getParent();
        boolean isUserModerator = this.confUtilities_m.isUserModerator(user, parent.getIdAsString());
        boolean isUserAdministrator = this.confluenceUtilities_m.isUserAdministrator(user, conversionContext.getSpaceKey());
        boolean isUserPageOwner = page.getCreator() != null && page.getCreator().equals(user);
        try {
            showLabels = (Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showLabels);
        }
        catch (Exception e) {
            showLabels = Boolean.parseBoolean((String)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showLabels));
        }
        if (this.licenseCheck_m.isLicenseOK("Easy Forums")) {
            int maxLikes = 0;
            Comment mostPopComment = null;
            List mostPopLikes = null;
            String heartUrl = "download/resources/net.kentcom.easy-forums:easy-forums-resources/images/heart.jpg";
            String thumbUrl = "download/resources/net.kentcom.easy-forums:easy-forums-resources/images/thumb-up.jpg";
            SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy");
            List comments = page.getComments();
            for (Comment comment : comments) {
                List likes = this.likeManager_m.getLikes((ContentEntityObject)comment);
                int count = likes.size();
                if (count <= maxLikes && mostPopComment != null) continue;
                mostPopComment = comment;
                mostPopLikes = likes;
                maxLikes = count;
            }
            Map context = MacroUtils.defaultVelocityContext();
            context.put("numLikes", maxLikes);
            context.put("heartUrl", heartUrl);
            context.put("thumbUrl", thumbUrl);
            context.put("showAvatar", this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showAvatar));
            context.put("youLike", false);
            context.put("noAnswer", true);
            if (mostPopComment != null) {
                context.put("noAnswer", false);
                context.put("mostPopId", mostPopComment.getIdAsString());
                context.put("avatarWithHtml", this.confluenceUtilities_m.getImageUrlString(mostPopComment.getLastModifier(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")) + "  ");
                try {
                    context.put("lastModifier", mostPopComment.getLastModifier().getFullName());
                }
                catch (Exception e) {
                    context.put("lastModifier", this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous"));
                }
                context.put("lastModDate", dateFormat.format(mostPopComment.getLastModificationDate()));
                try {
                    context.put("mostPopCommentWithHtml", this.xhtmlContent_m.convertStorageToView(mostPopComment.getBodyAsString(), conversionContext));
                }
                catch (Exception e) {
                    this.logger_m.error(e.toString());
                }
            }
            if (mostPopLikes != null) {
                for (Like like : mostPopLikes) {
                    if (user == null || !like.getUsername().matches(user.getName())) continue;
                    context.put("youLike", true);
                    break;
                }
            }
            builder.append(VelocityUtils.getRenderedTemplate((String)"templates/topic-macro.vm", (Map)context));
        } else {
            builder.append("<p><h3>");
            builder.append(this.i18nResolver_m.getText("net.kentcom.easy-forums.unlicensed"));
            builder.append("</h3></p>");
        }
        builder.append(this.confUtilities_m.hidePageElements(!isUserAdministrator && !isUserModerator && !isUserPageOwner, false, this.getTopicStatus(page) == StatusType.Read_Only || !this.permissionManager_m.hasCreatePermission((User)user, (Object)page, Comment.class) || !this.permissionManager_m.hasPermission((User)user, Permission.EDIT, (Object)parent), !showLabels, !isUserAdministrator && !isUserModerator, !isUserAdministrator && !isUserModerator));
        return builder.toString();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private Integer getTopicStatus(Page topic) {
        Integer statusId = this.statusType_m.getPageStatus(topic.getParent());
        if (statusId == StatusType.Read_Only) {
            return statusId;
        }
        statusId = this.statusType_m.getPageStatus(topic);
        if (statusId == null) {
            return StatusType.Active;
        }
        return statusId;
    }
}

