/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.inject.Named;
import net.kentcom.easyforums.EasyForumsConstants;
import net.kentcom.easyforums.IndexedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class StatusType
extends IndexedType {
    private final I18nResolver i18nResolver_m;
    private boolean initialised_m = false;
    public static Integer Active = -1;
    public static Integer Read_Only = -2;
    public static Integer Hidden = -3;
    private final Logger logger_m = LoggerFactory.getLogger(StatusType.class);

    public StatusType(@ComponentImport I18nResolver i18nResolver, @ComponentImport BandanaManager bandanaManager) {
        super(bandanaManager);
        this.i18nResolver_m = i18nResolver;
    }

    public void initialise() {
        if (!this.initialised_m) {
            this.addSystemValue(Active, this.i18nResolver_m.getText("net.kentcom.easy-forums.status.active"));
            this.addSystemValue(Read_Only, this.i18nResolver_m.getText("net.kentcom.easy-forums.status.readonly"));
            this.addSystemValue(Hidden, this.i18nResolver_m.getText("net.kentcom.easy-forums.status.hidden"));
            this.initialised_m = true;
        }
    }

    public Integer getPageStatus(Page page) {
        Integer statusId = 0;
        try {
            statusId = (Integer)this.bandanaManager_m.getValue(EasyForumsConstants.m_statusContext, page.getIdAsString());
            if (statusId == null) {
                statusId = Active;
            } else if (this.getValue(statusId) == null) {
                statusId = Active;
            }
        }
        catch (Exception e) {
            this.logger_m.error("Found old entry upgrading to later version");
            try {
                Object status = this.bandanaManager_m.getValue(EasyForumsConstants.m_statusContext, page.getIdAsString());
                statusId = status.toString().equals("Hidden") ? Hidden : (status.toString().equals("Read_Only") ? Read_Only : Active);
            }
            catch (Exception ex) {
                statusId = Active;
            }
            this.bandanaManager_m.setValue(EasyForumsConstants.m_statusContext, page.getIdAsString(), (Object)statusId);
        }
        return statusId;
    }

    public String getStatusLink(Page topic, Integer statusId, Boolean statusOverridden, Boolean isModerator) {
        String statusStr;
        String linkText = statusStr = this.getValue(statusId);
        if (isModerator.booleanValue()) {
            if (statusOverridden.booleanValue()) {
                linkText = this.getValue(this.getPageStatus(topic)) + " (" + this.i18nResolver_m.getText("net.kentcom.easy-forums.status.readonly") + ")";
            }
            return "<a class=\"setstatus\" href=\"#\" data-easy-forums-pageid=\"" + topic.getIdAsString() + "\" data-easy-forums-status=\"" + statusStr + "\">" + linkText + "</a>";
        }
        return statusStr;
    }
}

