/*
 * Decompiled with CFR 0.152.
 */
package net.kentcom.easyforums;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.kentcom.common.AppConfigSettings;
import net.kentcom.common.ConfluenceUtilities;
import net.kentcom.common.HtmlTableEntry;
import net.kentcom.common.LicenseCheck;
import net.kentcom.common.MapUtil;
import net.kentcom.common.SortedArrayList;
import net.kentcom.easyforums.ConfUtilities;
import net.kentcom.easyforums.EasyForumsConstants;
import net.kentcom.easyforums.ForumListener;
import net.kentcom.easyforums.StatusType;
import net.kentcom.easyforums.TableColumnHeadings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForumSummaryMacro
implements Macro {
    private final BandanaManager bandanaManager_m;
    private final PageManager pageManager_m;
    private final CommentManager commentManager_m;
    private final SettingsManager settingsManager_m;
    private final ConfUtilities confUtilities_m;
    private final AppConfigSettings appConfigSetting_m;
    private final ForumListener forumListener_m;
    private final I18nResolver i18nResolver_m;
    private final PermissionManager permissionManager_m;
    private final LicenseCheck licenseCheck_m;
    private final StatusType statusType_m;
    private final ConfluenceUtilities confluenceUtilities_m;
    private final PageBuilderService pageBuilderService_m;
    private final Logger logger_m = LoggerFactory.getLogger(ForumSummaryMacro.class);
    private Boolean isUserModerator_m = false;
    private Boolean isUserAdministrator_m = false;
    private Boolean showHiddenContent_m = false;
    private Boolean showAvatars_m;
    private EasyForumsConstants.SummaryColumns sortColumn_m;

    @Inject
    public ForumSummaryMacro(@ComponentImport BandanaManager bandanaManager, @ComponentImport PageManager pageManager, @ComponentImport CommentManager commentManager, @ComponentImport SettingsManager settingsManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionManager permissionManager, @ComponentImport PageBuilderService pageBuilderService, ForumListener forumListener, AppConfigSettings appConfigSetting, ConfUtilities confUtilities, LicenseCheck licenseCheck, StatusType statusType, ConfluenceUtilities confluenceUtilities) {
        this.bandanaManager_m = bandanaManager;
        this.pageManager_m = pageManager;
        this.commentManager_m = commentManager;
        this.settingsManager_m = settingsManager;
        this.forumListener_m = forumListener;
        this.i18nResolver_m = i18nResolver;
        this.permissionManager_m = permissionManager;
        this.appConfigSetting_m = appConfigSetting;
        this.confUtilities_m = confUtilities;
        this.licenseCheck_m = licenseCheck;
        this.statusType_m = statusType;
        this.confluenceUtilities_m = confluenceUtilities;
        this.pageBuilderService_m = pageBuilderService;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        this.pageBuilderService_m.assembler().resources().requireWebResource("net.kentcom.easy-forums:easy-forums-resources");
        this.statusType_m.initialise();
        Integer myId = (Integer)conversionContext.getProperty("EasyForums-ForumSummaryMacro", (Object)1);
        if (myId > 1) {
            return "<div><b><em>" + this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.duperror") + "</em></b></div>";
        }
        conversionContext.setProperty("EasyForums-ForumSummaryMacro", (Object)(myId + 1));
        StringBuilder builder = new StringBuilder();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Page page = (Page)conversionContext.getEntity();
        boolean renderTableOnly = (Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_renderTablesOnly);
        int max = (Integer)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_maxTableItems);
        String showHiddenStr = null;
        if (user != null) {
            showHiddenStr = (String)this.bandanaManager_m.getValue(EasyForumsConstants.m_showHiddenContext, user.getKey().getStringValue());
        }
        this.showHiddenContent_m = showHiddenStr != null && showHiddenStr.equals("true");
        this.isUserAdministrator_m = this.confluenceUtilities_m.isUserAdministrator(user, conversionContext.getSpaceKey());
        this.isUserModerator_m = this.confUtilities_m.isUserModerator(user, page.getIdAsString());
        this.showAvatars_m = (Boolean)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_showAvatar);
        String sortColumn = (String)this.appConfigSetting_m.getSetting(EasyForumsConstants.m_defaultSortColumn);
        this.sortColumn_m = EasyForumsConstants.SummaryColumns.LAST_POST;
        if (sortColumn.toUpperCase().equals(EasyForumsConstants.ForumColumns.NAME.name())) {
            this.sortColumn_m = EasyForumsConstants.SummaryColumns.NAME;
        } else if (sortColumn.toUpperCase().equals(EasyForumsConstants.ForumColumns.STATUS.name())) {
            this.sortColumn_m = EasyForumsConstants.SummaryColumns.STATUS;
        }
        if (this.licenseCheck_m.isLicenseOK("Easy Forums")) {
            SortedArrayList<HtmlTableEntry> forums = new SortedArrayList<HtmlTableEntry>();
            if (this.isUserAdministrator_m.booleanValue() || this.isUserModerator_m.booleanValue()) {
                builder.append(this.addEditModeratorsControl(user, page.getIdAsString()));
            }
            if (!renderTableOnly) {
                builder.append(this.confUtilities_m.renderSearchBox(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.search"), conversionContext));
                builder.append(this.addModerators());
            }
            if (this.isUserAdministrator_m.booleanValue() || this.isUserModerator_m.booleanValue()) {
                builder.append(this.confUtilities_m.addCreateNewButton(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.new"), "easy-forums-forum-blueprint", conversionContext, true));
            }
            if (this.isUserAdministrator_m.booleanValue()) {
                builder.append(this.addEditSpaceButton(conversionContext.getSpaceKey()));
            }
            Map context = MacroUtils.defaultVelocityContext();
            ArrayList<List> data = new ArrayList<List>();
            context.put("tableHeadings", this.addColumnHeadings());
            context.put("isAdmin", this.isUserAdministrator_m != false || this.isUserModerator_m != false);
            context.put("version", this.licenseCheck_m.getPluginVersion());
            context.put("class", "ef-summary-heading");
            this.createListOfForums(page, forums, user);
            int count = 0;
            for (HtmlTableEntry entry : forums) {
                data.add((List)entry.row_m);
                if (++count < max) continue;
                break;
            }
            context.put("tableData", data);
            builder.append(VelocityUtils.getRenderedTemplate((String)"templates/forum-macro.vm", (Map)context));
        } else {
            builder.append("<p><h3>");
            builder.append(this.i18nResolver_m.getText("net.kentcom.easy-forums.unlicensed"));
            builder.append("</h3></p>");
        }
        builder.append(this.confUtilities_m.hidePageElements(this.isUserAdministrator_m == false && this.isUserModerator_m == false, true, false, true, this.isUserAdministrator_m == false && this.isUserModerator_m == false, this.isUserAdministrator_m == false && this.isUserModerator_m == false));
        return builder.toString();
    }

    private List<TableColumnHeadings> addColumnHeadings() {
        ArrayList<TableColumnHeadings> headers = new ArrayList<TableColumnHeadings>();
        ForumListener.SummaryMap summaryMap = this.forumListener_m.getSummaryMap();
        for (EasyForumsConstants.SummaryColumns column : EasyForumsConstants.SummaryColumns.values()) {
            ForumListener.ColumnAttributes attr = (ForumListener.ColumnAttributes)summaryMap.get((Object)column);
            if (attr == null || !attr.isVisible().booleanValue()) continue;
            if (column == EasyForumsConstants.SummaryColumns.SUBSCRIBE) {
                String baseUrl = this.settingsManager_m.getGlobalSettings().getBaseUrl();
                String infoUrl = baseUrl + "/download/resources/net.kentcom.easy-forums:easy-forums-resources/images/info.jpg";
                String name = "<abbr title=\"" + this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.subscribe") + "\">" + attr.Name() + "&nbsp;&nbsp;<img src=\"" + infoUrl + "\" style=\"padding-top:2px\" align=\"top\" width=\"15\" height=\"15\"></abbr>";
                headers.add(new TableColumnHeadings(name, attr.Name()));
                continue;
            }
            headers.add(new TableColumnHeadings(attr.Name(), attr.Name()));
        }
        return headers;
    }

    private List<String> addDataToRow(Map<EasyForumsConstants.SummaryColumns, String> data, Map<EasyForumsConstants.SummaryColumns, String> avatar) {
        ArrayList<String> row = new ArrayList<String>();
        ForumListener.SummaryMap summaryMap = this.forumListener_m.getSummaryMap();
        for (EasyForumsConstants.SummaryColumns column : EasyForumsConstants.SummaryColumns.values()) {
            ForumListener.ColumnAttributes attr = (ForumListener.ColumnAttributes)summaryMap.get((Object)column);
            if (!attr.isVisible().booleanValue()) continue;
            String cell = "";
            if (column == EasyForumsConstants.SummaryColumns.BY_USER && this.showAvatars_m.booleanValue() && avatar != null) {
                cell = avatar.get((Object)column);
            }
            if (data != null) {
                cell = cell + data.get((Object)column);
            }
            row.add(cell);
        }
        return row;
    }

    private void createListOfForums(Page parent, SortedArrayList<HtmlTableEntry> table, ConfluenceUser user) {
        List forums = parent.getChildren();
        for (Page page : forums) {
            this.logger_m.debug("Found child page: " + page.getTitle());
            if (!EasyForumsConstants.isPageForum((Labelable)page)) continue;
            this.addForumToTable(page, table, user);
        }
    }

    private void addForumToTable(Page forum, SortedArrayList<HtmlTableEntry> table, ConfluenceUser user) {
        EnumMap<EasyForumsConstants.SummaryColumns, String> data = new EnumMap<EasyForumsConstants.SummaryColumns, String>(EasyForumsConstants.SummaryColumns.class);
        EnumMap<EasyForumsConstants.SummaryColumns, String> avatar = new EnumMap<EasyForumsConstants.SummaryColumns, String>(EasyForumsConstants.SummaryColumns.class);
        List topics = forum.getChildren();
        int numTopics = 0;
        int numPosts = 0;
        HtmlTableEntry entry = new HtmlTableEntry();
        Integer statusId = this.statusType_m.getPageStatus(forum);
        String anonymous = this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous");
        this.logger_m.info("Processing " + forum.getTitle());
        if (!(statusId != StatusType.Hidden || (this.isUserAdministrator_m.booleanValue() || this.isUserModerator_m.booleanValue()) && this.showHiddenContent_m.booleanValue())) {
            this.logger_m.info("This forum is hidden - skipping");
            return;
        }
        if (this.permissionManager_m.hasPermission((User)user, Permission.VIEW, (Object)forum)) {
            for (Page topic : topics) {
                if (!EasyForumsConstants.isPageTopic((Labelable)topic)) continue;
                List comments = topic.getComments();
                numPosts += comments.size() + 1;
                ++numTopics;
            }
            Long ceoId = (Long)this.bandanaManager_m.getValue(EasyForumsConstants.m_bandanaContext, forum.getIdAsString());
            data.put(EasyForumsConstants.SummaryColumns.LAST_POST, "");
            data.put(EasyForumsConstants.SummaryColumns.BY_USER, "");
            avatar.put(EasyForumsConstants.SummaryColumns.BY_USER, "");
            entry.id_m = "0";
            if (ceoId != null) {
                Page ceo = this.pageManager_m.getPage(ceoId.longValue());
                if (ceo == null) {
                    ceo = this.commentManager_m.getComment(ceoId.longValue());
                }
                if (ceo != null) {
                    Date lastModDate = ceo.getLastModificationDate();
                    data.put(EasyForumsConstants.SummaryColumns.LAST_POST, EasyForumsConstants.m_dateFormat.format(lastModDate));
                    try {
                        data.put(EasyForumsConstants.SummaryColumns.BY_USER, ceo.getLastModifier().getFullName());
                    }
                    catch (Exception e) {
                        data.put(EasyForumsConstants.SummaryColumns.BY_USER, anonymous);
                    }
                    avatar.put(EasyForumsConstants.SummaryColumns.BY_USER, this.confluenceUtilities_m.getImageUrlString(ceo.getLastModifier(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")) + "  ");
                    entry.id_m = EasyForumsConstants.m_sortFormat.format(lastModDate);
                }
            }
            data.put(EasyForumsConstants.SummaryColumns.STATUS, this.statusType_m.getStatusLink(forum, statusId, false, this.isUserModerator_m != false || this.isUserAdministrator_m != false));
            data.put(EasyForumsConstants.SummaryColumns.NAME, this.confluenceUtilities_m.getHtmlLink((ContentEntityObject)forum));
            data.put(EasyForumsConstants.SummaryColumns.NUM_TOPICS, Integer.toString(numTopics));
            data.put(EasyForumsConstants.SummaryColumns.NUM_POSTS, Integer.toString(numPosts));
            data.put(EasyForumsConstants.SummaryColumns.TOP_CONTRIBUTORS, this.getTopContributors(forum));
            data.put(EasyForumsConstants.SummaryColumns.SUBSCRIBE, this.confUtilities_m.getWatchLink(forum, user));
            entry.row_m = this.addDataToRow(data, avatar);
            if (this.sortColumn_m == EasyForumsConstants.SummaryColumns.NAME) {
                entry.id_m = forum.getTitle();
            } else if (this.sortColumn_m == EasyForumsConstants.SummaryColumns.STATUS) {
                entry.id_m = this.statusType_m.getValue(statusId);
            }
            table.insertSorted(entry);
        } else {
            this.logger_m.info("User does not have View permissions to this page " + forum.getTitle());
        }
    }

    private String addModerators() {
        List<String> moderators = this.confluenceUtilities_m.getUsersInGroup(EasyForumsConstants.m_moderatorGroupName);
        StringBuilder names = new StringBuilder();
        StringBuilder emails = new StringBuilder();
        if (moderators.size() == 0) {
            names.append("<font color=\"red\"><b>");
            names.append(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.unknown", new Serializable[]{EasyForumsConstants.m_moderatorGroupName}));
            names.append("</b></font> ");
        } else {
            for (String moderator : moderators) {
                this.logger_m.info("adding element");
                names.append(this.confluenceUtilities_m.getFullName(moderator));
                names.append(", ");
                emails.append(this.confluenceUtilities_m.getEmail(moderator));
                emails.append(";");
            }
        }
        this.logger_m.info(names.toString());
        this.logger_m.info(emails.toString());
        this.logger_m.info(this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.moderators", new Serializable[]{"test", "test"}));
        return "<p class=\"ef-text-centre\">" + this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.moderators", new Serializable[]{names, "<a href=\"mailto:" + emails + "\" class=\"external-link\" rel=\"nofollow\">email</a>"}) + "</p><br>";
    }

    private String getTopContributors(Page forum) {
        StringBuilder builder = new StringBuilder();
        Map<ConfluenceUser, Integer> topContributors = new HashMap();
        for (Page topic : forum.getChildren()) {
            ConfluenceUser creator = topic.getCreator();
            if (creator == null) continue;
            Integer freq = (Integer)topContributors.get(creator);
            topContributors.put(creator, freq == null ? 1 : freq + 1);
            for (Comment comment : topic.getComments()) {
                creator = comment.getCreator();
                if (creator == null) continue;
                freq = (Integer)topContributors.get(creator);
                topContributors.put(creator, freq == null ? 1 : freq + 1);
            }
        }
        int maxSize = 5;
        int count = 0;
        topContributors = MapUtil.sortByValue(topContributors, false);
        for (Map.Entry entry : topContributors.entrySet()) {
            if (count > 0) {
                if (this.showAvatars_m.booleanValue()) {
                    builder.append("  ");
                } else {
                    builder.append(", ");
                }
            }
            if (this.showAvatars_m.booleanValue()) {
                for (int i = 1; i <= 5; ++i) {
                    builder.append(this.confluenceUtilities_m.getImageUrlString((ConfluenceUser)entry.getKey(), this.i18nResolver_m.getText("net.kentcom.easy-forums.forum.anonymous")));
                    builder.append("  ");
                }
            } else {
                builder.append(((ConfluenceUser)entry.getKey()).getFullName());
            }
            if (count++ != maxSize) continue;
            break;
        }
        return builder.toString();
    }

    private String addEditSpaceButton(String spaceKey) {
        return "<a href=\"" + this.settingsManager_m.getGlobalSettings().getBaseUrl() + "/spaces/viewspacesummary.action?key=" + spaceKey + "\"><button class=\"aui-button\" style=\"float: right;\">" + this.i18nResolver_m.getText("net.kentcom.easy-forums.summary.admin") + "</button></a>";
    }

    private String addEditModeratorsControl(ConfluenceUser user, String pageId) {
        Map context = MacroUtils.defaultVelocityContext();
        String userKey = user.getKey().getStringValue();
        context.put("userKey", userKey);
        context.put("checked", (String)this.bandanaManager_m.getValue(EasyForumsConstants.m_showHiddenContext, userKey));
        return VelocityUtils.getRenderedTemplate((String)"templates/summary-settings.vm", (Map)context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

